/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.jalbum.component.JQRComponent;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import se.datadosen.component.JNotification;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Sounds;
import se.datadosen.jalbum.Tracer;
import se.datadosen.net.NetUtil;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.MyJSONObject;
import se.datadosen.util.Replacer;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import xyz.gianlu.zeroconf.Service;
import xyz.gianlu.zeroconf.Zeroconf;

public class FileReceivingServer
extends JSmartDialog {
    private static FileReceivingServer instance;
    private Server server;
    private int port;
    private final JAlbumExplorer explorer;
    JLabel message = new WrappableJLabel(Msg.get("ui.addFromPhoneMessage"));
    JQRComponent qrComp = new JQRComponent();
    JProgressBar progressBar = new JProgressBar();
    Zeroconf zeroconf = new Zeroconf();
    Service service;
    ScheduledFuture stopFuture;
    Action closeAction = new AbstractAction(Msg.get("close")){

        @Override
        public void actionPerformed(ActionEvent e) {
            FileReceivingServer.this.setVisible(false);
        }
    };

    private void rescheduleStop() {
        if (this.stopFuture != null) {
            this.stopFuture.cancel(true);
        }
        this.stopFuture = JAlbumUtilities.schedule(() -> {
            this.server.stop();
            System.out.println("File transfer server stopped due to inactivity");
            if (this.service != null) {
                this.zeroconf.unannounce(this.service);
            }
            return null;
        }, 5L, TimeUnit.MINUTES);
    }

    @Override
    public void setVisible(boolean visible) {
        block7: {
            super.setVisible(visible);
            try {
                if (visible) {
                    if (this.stopFuture != null) {
                        this.stopFuture.cancel(true);
                        this.stopFuture = null;
                    }
                    this.progressBar.setValue(0);
                    this.progressBar.setString("");
                    this.progressBar.setIndeterminate(false);
                    if (!this.server.isRunning()) {
                        this.server.start();
                        System.out.println("File transfer server listening on port " + this.port);
                        URL u = new URL("http", NetUtil.getLocalHostAddress(), this.port, "/send");
                        this.qrComp.setUrl(u.toExternalForm());
                        LogManager.getLogManager().getLogger("xyz.gianlu.zeroconf.Zeroconf").setLevel(Level.WARNING);
                        new Thread(() -> {
                            this.service = new Service("jAlbum", "http", this.port).putText("url", u.toExternalForm());
                            this.zeroconf.announce(this.service);
                        }).start();
                    }
                    try {
                        this.zeroconf.setUseIpv4(true).setUseIpv6(false).addAllNetworkInterfaces();
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Zeroconf)this.zeroconf).close()));
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(this.explorer, ex);
                    }
                    this.pack();
                    break block7;
                }
                this.rescheduleStop();
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    public FileReceivingServer(JAlbumExplorer explorer) {
        super(explorer.parent, Msg.get("ui.addFromPhoneTitle"), false);
        this.explorer = explorer;
        this.port = NetUtil.getFreeServerPort(8090);
        this.server = new Server(this.port);
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        this.server.setHandler((Handler)handler);
        ServletHolder holder = new ServletHolder((Servlet)new FileReceivingServlet());
        handler.addServlet(holder, "/send");
        this.registerActions(this.closeAction);
        this.progressBar.setStringPainted(true);
        this.getContentPane().setLayout(new RiverLayout());
        this.add("center", this.qrComp);
        this.add("br hfill", this.message);
        this.add("br left hfill", this.progressBar);
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
        help.add((JComponent)this.getContentPane(), "AddFromPhone");
        this.pack();
    }

    static void show(JAlbumExplorer explorer) {
        Tracer.getInstance().trace("add from phone dialog opened");
        FileReceivingServer.getInstance(explorer).setVisible(true);
    }

    private static FileReceivingServer getInstance(JAlbumExplorer explorer) {
        if (instance == null) {
            instance = new FileReceivingServer(explorer);
        }
        return instance;
    }

    class FileReceivingServlet
    extends HttpServlet {
        FileReceivingServlet() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
            if (!isMultipart) {
                return;
            }
            JNotification note = new JNotification(Msg.get("ui.receivingFiles") + "...", JNotification.Type.INFO);
            note.setExpiration(6);
            note.setPriority(JNotification.Priority.HIGH);
            FileReceivingServer.this.explorer.parent.showNotification(note);
            File targetFile = null;
            try {
                if (FileReceivingServer.this.stopFuture != null) {
                    FileReceivingServer.this.rescheduleStop();
                }
                Sounds.play("Blow.aiff");
                FileReceivingServer.this.progressBar.setIndeterminate(true);
                FileReceivingServer.this.progressBar.setString(Msg.get("ui.receivingFiles"));
                resp.setContentType("application/json");
                File targetDir = FileReceivingServer.this.explorer.getCurrentFolder().getFile();
                if ("".equals(targetDir.getName())) {
                    IO.IMPORT_DIR.mkdirs();
                    targetDir = IO.IMPORT_DIR;
                }
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(req);
                int i = 0;
                int fileCount = 10;
                byte[] buf = new byte[262144];
                Stopwatch sw = new Stopwatch().start();
                long totalBytes = 0L;
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    String fieldName = item.getFieldName();
                    InputStream in = item.openStream();
                    try {
                        if (item.isFormField()) {
                            if (!"fileCount".equals(fieldName)) continue;
                            fileCount = Integer.parseInt(Streams.asString((InputStream)in));
                            SwingUtilities.invokeLater(() -> FileReceivingServer.this.progressBar.setIndeterminate(false));
                            FileReceivingServer.this.progressBar.setMaximum(fileCount);
                            Tracer.getInstance().trace("receiving files from phone", "fileCount:" + fileCount);
                            continue;
                        }
                        String fileName = item.getName();
                        if ("".equals(fileName) || fileName == null) continue;
                        FileReceivingServer.this.progressBar.setString(Msg.get("ui.receivingFile", i + 1, fileCount));
                        targetFile = new File(targetDir, fileName);
                        long fileBytes = 0L;
                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));){
                            int n;
                            while ((n = in.read(buf)) > 0) {
                                os.write(buf, 0, n);
                                fileBytes += (long)n;
                                totalBytes += (long)n;
                            }
                        }
                        FileReceivingServer.this.progressBar.setValue(++i);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                sw.stop();
                resp.setStatus(200);
                MyJSONObject json = new MyJSONObject();
                json.put("status", "ok");
                json.put("fileCount", i);
                json.toJson(resp.getWriter());
                if (i > 0) {
                    System.out.println(Msg.get("ui.receivedNFilesTimed", i, new DataAmount(totalBytes), Config.getConfig().getDateFormatter().format(new Date()), sw, String.valueOf(new DataAmount((double)totalBytes / sw.getSecs())) + "/s"));
                    Sounds.play("Ping.aiff");
                    String okMessage = Msg.get("ui.receivedNFiles", i, Config.getConfig().getDateFormatter().format(new Date()));
                    note = new JNotification(okMessage, JNotification.Type.INFO);
                    note.setExpiration(6);
                    note.setPriority(JNotification.Priority.HIGH);
                    FileReceivingServer.this.explorer.parent.showNotification(note);
                    if (targetDir == IO.IMPORT_DIR) {
                        SwingUtilities.invokeLater(() -> {
                            JNewProjectDialog newProjectDialog = new JNewProjectDialog(FileReceivingServer.this.explorer.parent);
                            String albumNameSuggestion = this.findAlbumNameSuggestion();
                            newProjectDialog.setAlbumName(albumNameSuggestion);
                            newProjectDialog.setFiles(Arrays.asList(IO.IMPORT_DIR.listFiles()), 2);
                            FileReceivingServer.this.explorer.parent.show(newProjectDialog);
                        });
                    }
                }
                if (!FileReceivingServer.this.qrComp.isKeepOpen()) {
                    JAlbumUtilities.schedule(() -> FileReceivingServer.this.setVisible(false), 2L, TimeUnit.SECONDS);
                }
            }
            catch (EOFException ex) {
                Debug.showErrorDialog(FileReceivingServer.this.explorer, "Transfer aborted for " + targetFile.getName(), ex);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                throw ex;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace(System.err);
                throw ex;
            }
            catch (FileUploadException ex) {
                ex.printStackTrace(System.err);
                throw new ServletException((Throwable)ex);
            }
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/html");
            resp.setStatus(200);
            Replacer r = new Replacer();
            SmartResourceBundle rb = Msg.getResourceBundle();
            for (String key : rb.getKeys()) {
                if (!key.startsWith("afp.")) continue;
                r.add("${" + key.substring(4) + "}", rb.getString(key));
            }
            try (FileReader reader = new FileReader(new File(Config.getConfig().progDir, "system/fileupload.html"), Charset.forName("UTF8"));){
                r.processStreams(reader, resp.getWriter());
            }
        }

        private String findAlbumNameSuggestion() {
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern("MMM d", Locale.getDefault());
            String suggestedName = Msg.get("ui.myPhone") + " " + fmt.format(LocalDate.now());
            File myAlbumsDir = new File(Config.getConfig().getMyAlbumsLocation());
            return IO.ensureUnique(myAlbumsDir, suggestedName).getName();
        }
    }

    private static class DataAmount {
        private String kiloUnit = "KB";
        private String megaUnit = "MB";
        private double byteRate;
        private DecimalFormat oneDec = new DecimalFormat("0.0");

        public DataAmount(double byteRate) {
            this.byteRate = byteRate;
        }

        public String toString() {
            if (this.byteRate > 1048576.0) {
                return this.formatAsMega(this.byteRate) + " " + this.megaUnit;
            }
            return this.formatAsKilo(this.byteRate) + " " + this.kiloUnit;
        }

        protected String formatAsMega(double value) {
            return this.oneDec.format(value / 1024.0 / 1024.0);
        }

        protected String formatAsKilo(double value) {
            return this.oneDec.format(value / 1024.0);
        }
    }
}

