/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import se.datadosen.component.JSmartTextField;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;

class FileNameEditor
extends JAlbumObject.LabelEditor {
    private AlbumObject ao;
    private boolean editing;
    private JLabel label = new JLabel();
    private JTextField nameField = new JSmartTextField();

    public FileNameEditor(JAlbumObject jao) {
        super(jao);
        this.ao = jao.ao;
        this.init();
    }

    private void init() {
        this.refresh();
        this.label.setOpaque(false);
        this.label.setHorizontalAlignment(0);
        int labelW = this.jao.context.getIconBounds().width;
        int labelH = this.label.getPreferredSize().height;
        this.label.setPreferredSize(new Dimension(labelW, labelH));
        this.nameField.setDocument(new FileNameDocument());
        this.nameField.addActionListener(ae -> {
            if (this.verifyInput()) {
                this.setEditing(false);
            }
        });
        this.nameField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                AlbumBean engine;
                String text = ((JTextField)input).getText();
                return !text.equals((engine = FileNameEditor.this.jao.ao.getEngine()).getSlideDirectory()) && !text.equals(engine.getThumbnailDirectory());
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    FileNameEditor.this.nameField.setText(FileNameEditor.this.ao.getName());
                    FileNameEditor.this.setEditing(false);
                }
            }
        });
        this.nameField.setFont(this.label.getFont());
        this.nameField.setText(this.label.getText());
        int nameFieldW = this.jao.context.getIconBounds().width;
        int nameFieldH = this.nameField.getPreferredSize().height;
        this.nameField.setPreferredSize(new Dimension(nameFieldW, nameFieldH));
        this.setLayout(new FlowLayout(1, 0, 3));
        this.setOpaque(false);
        this.add(this.label);
        this.nameField.setVisible(false);
        this.add(this.nameField);
        int maxWidth = Math.max(this.label.getPreferredSize().width, this.nameField.getPreferredSize().width);
        int maxHeight = Math.max(this.label.getPreferredSize().height, this.nameField.getPreferredSize().height);
        this.setPreferredSize(new Dimension(maxWidth, maxHeight + 3));
    }

    private boolean verifyInput() {
        InputVerifier verifier = this.nameField.getInputVerifier();
        if (verifier != null && !verifier.verify(this.nameField)) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.nameField, Msg.get("ui.illegalName", this.nameField.getText()), Msg.get("ui.illegalNameTitle"), 0);
            return false;
        }
        return true;
    }

    @Override
    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        this.jao.context.context.setEnableRefresh(!editing);
        if (this.nameField.hasFocus()) {
            this.jao.requestFocusInWindow();
        }
        this.nameField.setVisible(editing);
        this.label.setVisible(!editing);
        if (editing) {
            this.nameField.setText(this.ao.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.ao.getName().length());
            this.validate();
            this.nameField.requestFocusInWindow();
        } else if (this.verifyInput()) {
            String newName = this.nameField.getText();
            if (!newName.equals(this.ao.getName())) {
                this.setFileName(newName);
            }
            this.refresh();
            this.validate();
            this.repaint();
        } else {
            this.nameField.setText(this.ao.getName());
        }
    }

    @Override
    void refresh() {
        JAlbumUtilities.runOnAWT(() -> this.label.setText(this.ao.getName()));
    }

    @Override
    boolean isEditing() {
        return this.editing;
    }

    @Override
    void setSelected(boolean selected) {
        if (selected) {
            this.label.setOpaque(true);
            this.label.setForeground(JAlbumColor.textHighlightText);
            this.label.setBackground(JAlbumColor.textHighlight);
        } else {
            this.label.setOpaque(false);
            this.label.setForeground(JAlbumColor.textText);
        }
    }

    private void setFileName(String name) {
        if (!this.ao.setName(name)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

