/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.undo.EditGroup;
import se.datadosen.dnd.AbstractTreeTransferHandler;
import se.datadosen.explorer.FolderTreeNode;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;

public class ExplorerTreeTransferHandler
extends AbstractTreeTransferHandler {
    private JAlbumExplorer context;
    private JComponent albumRootComponent;

    public ExplorerTreeTransferHandler(JTree tree, JAlbumExplorer context) {
        this(tree, null, context);
    }

    public ExplorerTreeTransferHandler(JTree tree, JComponent albumRootComponent, JAlbumExplorer context) {
        super(tree, 0x40000003, true);
        this.context = context;
        if (albumRootComponent != null) {
            this.albumRootComponent = albumRootComponent;
            new DropTarget(albumRootComponent, this);
        }
    }

    @Override
    protected DefaultMutableTreeNode resolveTargetNode(Point pt, DropTargetContext dtc) {
        if (dtc != null && dtc.getComponent() == this.albumRootComponent) {
            return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        }
        return super.resolveTargetNode(pt, dtc);
    }

    @Override
    public boolean canDropNode(DropTargetContext dtc, DefaultMutableTreeNode draggedNode, int action, Point location) {
        DefaultMutableTreeNode parentNode = this.resolveTargetNode(location, dtc);
        if (parentNode == null) {
            return false;
        }
        if (draggedNode != null && (draggedNode.isRoot() || parentNode == draggedNode.getParent() || draggedNode.isNodeDescendant(parentNode))) {
            return false;
        }
        this.tree.setSelectionPath(new TreePath(parentNode.getPath()));
        return true;
    }

    @Override
    public int albumObjectsDragged(DropTargetDragEvent dtde, int action, Point location) {
        DropTargetContext dtc = dtde.getDropTargetContext();
        DefaultMutableTreeNode targetNode = this.resolveTargetNode(location, dtc);
        if (targetNode == null) {
            this.tree.setSelectionPath(null);
            return 0;
        }
        this.tree.setSelectionPath(new TreePath(targetNode.getPath()));
        return action;
    }

    private static String dndActionsToString(int sa) {
        return ((sa & 1) != 0 ? "ACTION_COPY " : "") + ((sa & 2) != 0 ? "ACTION_MOVE " : "") + ((sa & 0x40000000) != 0 ? "ACTION_LINK " : "");
    }

    @Override
    public int filesDragged(DropTargetDragEvent dtde, int action, Point location) {
        DropTargetContext dtc = dtde.getDropTargetContext();
        DefaultMutableTreeNode targetNode = this.resolveTargetNode(location, dtc);
        if (targetNode == null) {
            this.tree.setSelectionPath(null);
            return 0;
        }
        this.tree.setSelectionPath(new TreePath(targetNode.getPath()));
        this.context.explorer.updateSourceActions(dtde);
        if (JAlbum.logger.isLoggable(Level.FINER)) {
            System.out.println("Dragged: Sourceactions: " + ExplorerTreeTransferHandler.dndActionsToString(dtde.getSourceActions()));
            System.out.println("Dragged: Dropaction: " + ExplorerTreeTransferHandler.dndActionsToString(dtde.getDropAction()));
            System.out.println("Dragged: Decision: " + ExplorerTreeTransferHandler.dndActionsToString(this.decideDropAction(dtde)));
            System.out.println("");
        }
        return this.context.explorer.decideDropAction(dtde);
    }

    @Override
    public int decideDropAction(DropTargetEvent dte) {
        return this.context.explorer.decideDropAction(dte);
    }

    @Override
    public boolean executeDrop(DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, DropTargetDropEvent dtde) throws IOException {
        AlbumObject moved = this.getAlbumObject(draggedNode);
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (moved != null && target != null) {
            return this.move(moved, target);
        }
        return false;
    }

    @Override
    public boolean executeDrop(List<File> droppedFiles, DefaultMutableTreeNode newParentNode, DropTargetDropEvent dtde) {
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (target != null) {
            this.context.explorer.closestObject = null;
            return !this.context.explorer.handleFileAdd(droppedFiles, this.context.explorer.decideDropAction(dtde, false), false);
        }
        return false;
    }

    @Override
    public boolean executeAlbumObjectDrop(DefaultMutableTreeNode newParentNode, DropTargetDropEvent dtde) throws IOException {
        List<JAlbumObject> draggedObjects = this.context.explorer.getDraggedObjects();
        int action = dtde.getDropAction();
        if ((action & 0x40000001) != 0) {
            return !this.context.explorer.handleFileAdd(draggedObjects.stream().map(jao -> jao.ao.getFile()).collect(Collectors.toList()), action, true);
        }
        AlbumObject[] moved = new AlbumObject[draggedObjects.size()];
        for (int i = 0; i < draggedObjects.size(); ++i) {
            moved[i] = draggedObjects.get((int)i).ao;
        }
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (moved != null && target != null) {
            return this.move(moved, target);
        }
        return false;
    }

    private AlbumObject getAlbumObject(DefaultMutableTreeNode node) {
        AlbumObject ao = null;
        if (node instanceof FolderTreeNode) {
            FolderTreeNode ftn = (FolderTreeNode)node;
            ao = ftn.getAlbumObject();
        }
        return ao;
    }

    private boolean move(AlbumObject moved, AlbumObject target) throws IOException {
        return this.move(new AlbumObject[]{moved}, target);
    }

    private boolean move(AlbumObject[] moved, AlbumObject target) throws IOException {
        try (EditGroup _v = new EditGroup(Msg.get("edit.move"));){
            for (AlbumObject ao : moved) {
                ao.moveTo(target);
            }
        }
        this.context.redraw();
        return true;
    }
}

