/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.event.SelectionListener;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.jalbum.AlbumObject;

public class ExplorerSelectionModel
implements StructureListener {
    private JAlbumObjectsPanel objectsPanel;
    public int lastClickedIndex = 0;
    public boolean wasAlreadySelected = false;
    private SoftReference<JAlbumObject> focusedObject;
    private int selectionCount = 0;
    private transient ArrayList<SelectionListener> selectionListeners;

    public ExplorerSelectionModel(JAlbumObjectsPanel panel) {
        this.objectsPanel = panel;
    }

    public ExplorerSelectionModel(JExplorerPanel panel) {
        this.objectsPanel = panel;
        panel.addStructureListener(this);
    }

    int indexOf(Component comp) {
        Component[] comps = this.objectsPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != comp) continue;
            return i;
        }
        return -1;
    }

    public void select(BiPredicate<JAlbumObject, Integer> pred) {
        ArrayList<SelectionListener> tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.objectsPanel.getComponents();
        int selCount = 0;
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            if (!jao.isVisible()) continue;
            boolean doSelect = pred.test(jao, i);
            jao.setSelected(doSelect);
            if (!doSelect) continue;
            ++selCount;
        }
        this.selectionListeners = tmpListeners;
        this.selectionCount = selCount;
        this.fireSelectionChange();
    }

    void selectAll() {
        this.select((jao, i) -> true);
    }

    public void deselectAll() {
        this.select((jao, i) -> false);
    }

    public void selectExcluded() {
        this.select((jao, i) -> !jao.ao.isIncluded());
    }

    public void invertSelection() {
        this.select((jao, i) -> !jao.isSelected());
    }

    public void selectSingle(JAlbumObject jao) {
        this.select((co, i) -> co == jao);
        this.lastClickedIndex = this.indexOf(jao);
        this.focusedObject = new SoftReference<JAlbumObject>(jao);
    }

    public void selectMatching(Collection<AlbumObject> list) {
        this.select((co, i) -> list.contains(co.ao));
    }

    public void selectRange(int startIndex, int endIndex) {
        int start = Math.min(startIndex, endIndex);
        int end = Math.max(startIndex, endIndex);
        this.select((co, i) -> i >= start && i <= end);
        this.lastClickedIndex = startIndex;
    }

    public int getSelectionCount() {
        return this.selectionCount;
    }

    void objectSelected(JAlbumObject jao, boolean selected) {
        this.selectionCount = selected ? ++this.selectionCount : --this.selectionCount;
        this.fireSelectionChange();
    }

    public List<JAlbumObject> getSelectedObjects() {
        return this.objectsPanel.objects().filter(jao -> jao.isSelected()).collect(Collectors.toCollection(ArrayList::new));
    }

    public JAlbumObject getSingleSelected() {
        Component[] comps;
        JAlbumObject selected = null;
        for (Component comp : comps = this.objectsPanel.getComponents()) {
            JAlbumObject jao = (JAlbumObject)comp;
            if (!jao.isSelected()) continue;
            if (selected != null) {
                return null;
            }
            selected = jao;
        }
        return selected;
    }

    public JAlbumObject getFocusedObject() {
        return this.focusedObject != null ? this.focusedObject.get() : null;
    }

    public void setFocusedObject(JAlbumObject jao) {
        this.focusedObject = new SoftReference<JAlbumObject>(jao);
        if (!jao.isFocusOwner()) {
            jao.requestFocusInWindow();
        }
    }

    public int indexOf(JAlbumObject jao) {
        Component[] comps = this.objectsPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != jao) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousRowY(JAlbumObject jao) {
        for (int i = this.indexOf(jao); i >= 0 && i != -1; --i) {
            int y = this.objectsPanel.getComponent(i).getY();
            if (y >= jao.getY()) continue;
            return y;
        }
        return jao.getY();
    }

    private int getNextRowY(JAlbumObject jao) {
        for (int i = this.indexOf(jao); i < this.objectsPanel.getComponentCount() && i != -1; ++i) {
            int y = this.objectsPanel.getComponent(i).getY();
            if (y <= jao.getY()) continue;
            return y;
        }
        return jao.getY();
    }

    public JAlbumObject getNeighbourObject(JAlbumObject jao, Direction direction) {
        Point p = jao.getLocation();
        Dimension dim = jao.getSize();
        switch (direction.ordinal()) {
            case 0: {
                p.y = this.getPreviousRowY(jao) + dim.height / 2;
                break;
            }
            case 1: {
                p.y = this.getNextRowY(jao) + dim.height / 2;
                break;
            }
            case 2: {
                p.x -= dim.width / 2 + this.objectsPanel.explorerThumbsLayout.getHgap();
                break;
            }
            case 3: {
                p.x += jao.getWidth() + dim.width / 2 + this.objectsPanel.explorerThumbsLayout.getHgap();
                break;
            }
            case 4: {
                int index = this.objectsPanel.indexOf(jao);
                return index > 0 ? (JAlbumObject)this.objectsPanel.getComponent(index - 1) : jao;
            }
            case 5: {
                int index2 = this.objectsPanel.indexOf(jao);
                return index2 < this.objectsPanel.getComponentCount() - 1 ? (JAlbumObject)this.objectsPanel.getComponent(index2 + 1) : jao;
            }
            case 6: {
                List<JAlbumObject> visible = this.objectsPanel.getVisibleObjects();
                JAlbumObject newJao = visible.get(0);
                return newJao != jao ? newJao : (JAlbumObject)this.objectsPanel.getComponent(Math.max(0, this.objectsPanel.indexOf(jao) - visible.size()));
            }
            case 7: {
                List<JAlbumObject> visible = this.objectsPanel.getVisibleObjects();
                JAlbumObject newJao = visible.get(visible.size() - 1);
                return newJao != jao ? newJao : (JAlbumObject)this.objectsPanel.getComponent(Math.min(this.objectsPanel.getComponentCount() - 1, this.objectsPanel.indexOf(jao) + visible.size()));
            }
        }
        return this.objectsPanel.getNearestObject(p);
    }

    public synchronized void removeSelectionListener(SelectionListener l) {
        if (this.selectionListeners != null && this.selectionListeners.contains(l)) {
            ArrayList<SelectionListener> newList = new ArrayList<SelectionListener>(this.selectionListeners);
            newList.remove(l);
            this.selectionListeners = newList;
        }
    }

    public synchronized void addSelectionListener(SelectionListener l) {
        ArrayList<SelectionListener> newList;
        ArrayList<SelectionListener> arrayList = newList = this.selectionListeners == null ? new ArrayList<SelectionListener>(2) : new ArrayList<SelectionListener>(this.selectionListeners);
        if (!newList.contains(l)) {
            newList.add(l);
            this.selectionListeners = newList;
        }
    }

    protected void fireSelectionChange() {
        if (this.selectionListeners != null) {
            for (SelectionListener listener : this.selectionListeners) {
                listener.selectionChange(this);
            }
        }
    }

    @Override
    public void structureChanged(StructureEvent e) {
        this.selectionCount = (int)this.objectsPanel.objects().filter(jao -> jao.isSelected()).count();
        this.fireSelectionChange();
    }

    public static enum Direction {
        NORTH,
        SOUTH,
        WEST,
        EAST,
        PREVIOUS,
        NEXT,
        PAGE_UP,
        PAGE_DOWN;

    }
}

