/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.datadosen.component.JHtmlEditor;
import se.datadosen.explorer.AbstractEditor;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;

class CaptionEditor
extends AbstractEditor {
    private final Action openHtmlEditorAction = new AbstractAction(Msg.get("ui.openHTMLEditor", Icons.small("edit-html"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            String result = JHtmlEditor.showEditor(CaptionEditor.this, CaptionEditor.this.readText(), CaptionEditor.this.jao.ao.getCategory() == Category.webPage);
            if (result != null) {
                try {
                    CaptionEditor.this.writeText(result);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(CaptionEditor.this.label, ex);
                }
            }
        }
    };

    public CaptionEditor(final JAlbumObject jao) {
        super(jao);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ CaptionEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handle(e);
            }

            private void doPopup(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                this.this$0.openHtmlEditorAction.putValue("Name", Msg.get("ui.openHTMLEditor"));
                this.this$0.openHtmlEditorAction.putValue("SmallIcon", Icons.small("edit-html"));
                popup.add(new JMenuItem(this.this$0.openHtmlEditorAction));
                Point p = e.getPoint();
                popup.show(this.this$0, p.x, p.y);
            }

            private void handle(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    jao.context.selectionModel.selectSingle(jao);
                    jao.context.selectionModel.setFocusedObject(jao);
                    this.doPopup(e);
                } else {
                    Component source = (Component)e.getSource();
                    source.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(source, e, source.getParent()));
                }
            }
        });
    }

    @Override
    protected JTextArea getEditArea() {
        if (this.editArea == null) {
            super.getEditArea();
            this.editArea.setAllowHTMLEditing(true);
            if (this.jao.ao.getCategory() == Category.webPage) {
                this.editArea.setFullHTMLEditing(true);
            }
        }
        return this.editArea;
    }

    @Override
    public String readText() {
        return this.ao.getComment();
    }

    @Override
    public void writeText(String text) throws IOException {
        this.ao.setComment(text);
        Tracer.getInstance().trace("caption edited", "location:explorer");
    }

    @Override
    public String getPromptText() {
        return Msg.get("ui.addCaption");
    }
}

