/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;
import se.datadosen.component.windows.jna.Comdlg32;

public class WindowsFileChooser
implements FileChooser {
    protected File[] selectedFiles;
    protected File currentDirectory;
    protected ArrayList<FileNameExtensionFilter> filters = new ArrayList();
    protected boolean multiSelectionEnabled;
    private final List actionListeners = new ArrayList();
    private int dialogType = 0;
    private boolean isApproved;
    private SecondaryLoop loop;

    @Override
    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionEnabled = b;
    }

    @Override
    public void setFileSelectionMode(int mode) {
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public void setFileView(FileView fileView) {
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        if (!(filter instanceof FileNameExtensionFilter)) {
            throw new IllegalArgumentException("filter is not a FileNameExtensionFilter");
        }
        this.filters.add((FileNameExtensionFilter)filter);
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        Window win = parent instanceof Window ? (Window)parent : SwingUtilities.windowForComponent(parent);
        boolean ok = this.showDialog(win, this.dialogType == 0 || this.dialogType == 2);
        if (ok) {
            this.notifyListeners("ApproveSelection");
            return 0;
        }
        this.notifyListeners("CancelSelection");
        return 1;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    @Override
    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    @Override
    public void setCurrentDirectory(File currentDirectory) {
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        } else {
            currentDirectory = null;
        }
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public void setSelectedFile(File file) {
        this.selectedFiles = new File[]{file};
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFiles != null ? this.selectedFiles[0] : null;
    }

    @Override
    public void setDialogTitle(String title) {
    }

    private void notifyListeners(String command) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, command);
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    boolean showDialog(final Window window, final boolean open) {
        this.selectedFiles = null;
        if (window == null) {
            throw new NullPointerException("Passing null window");
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue eq = tk.getSystemEventQueue();
        this.loop = eq.createSecondaryLoop();
        Thread bgThread = new Thread(this, "File chooser thread"){
            final /* synthetic */ WindowsFileChooser this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean approved;
                    Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
                    params.Flags = 0x88000C | (this.this$0.multiSelectionEnabled ? 512 : 0);
                    params.hwndOwner = Native.getWindowPointer((Window)window);
                    int bufferLength = 260000;
                    int bufferSize = 1040001;
                    params.lpstrFile = new Memory(1040001L);
                    params.lpstrFile.clear(1040001L);
                    params.nMaxFile = 260000;
                    if (this.this$0.currentDirectory != null) {
                        params.lpstrInitialDir = new WString(this.this$0.currentDirectory.getAbsolutePath());
                    }
                    if (this.this$0.filters.size() > 0) {
                        params.lpstrFilter = new WString(this.this$0.buildFilterString());
                        params.nFilterIndex = 1;
                    }
                    boolean bl = approved = open ? Comdlg32.GetOpenFileNameW(params) : Comdlg32.GetSaveFileNameW(params);
                    if (approved) {
                        byte[] bytes = params.lpstrFile.getByteArray(0L, 1040001);
                        try {
                            File dir;
                            String[] names = this.toStringArray(new String(bytes, "UTF-16LE"));
                            if (names.length == 1) {
                                this.this$0.selectedFiles = new File[]{new File(names[0])};
                            } else {
                                dir = new File(names[0]);
                                this.this$0.selectedFiles = new File[names.length - 1];
                                for (int i = 1; i < names.length; ++i) {
                                    this.this$0.selectedFiles[i - 1] = new File(dir, names[i]);
                                }
                            }
                            this.this$0.currentDirectory = dir = this.this$0.selectedFiles[0].getParentFile();
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        int errCode = Comdlg32.CommDlgExtendedError();
                        if (errCode != 0) {
                            throw new RuntimeException("GetOpenFileName failed with error " + errCode);
                        }
                    }
                    this.this$0.isApproved = approved;
                }
                finally {
                    this.this$0.loop.exit();
                }
            }

            private String[] toStringArray(String string) {
                String token;
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer tokens = new StringTokenizer(string, "\u0000");
                while (tokens.hasMoreTokens() && ((token = tokens.nextToken()).length() != 1 || token.charAt(0) != '\ufffd')) {
                    list.add(token);
                }
                return list.toArray(new String[list.size()]);
            }
        };
        bgThread.start();
        this.loop.enter();
        return this.isApproved;
    }

    private String buildFilterString() {
        StringBuilder filterStr = new StringBuilder();
        for (FileNameExtensionFilter filter : this.filters) {
            String label = filter.getDescription();
            filterStr.append(label);
            filterStr.append('\u0000');
            for (String ext : filter.getExtensions()) {
                filterStr.append("*.");
                filterStr.append(ext);
                filterStr.append(';');
            }
            filterStr.deleteCharAt(filterStr.length() - 1);
            filterStr.append('\u0000');
        }
        filterStr.append('\u0000');
        return filterStr.toString();
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }
}

