/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.tags;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class JTag
extends JLabel {
    private static final int MARGIN = 2;
    private static final int RADIUS = 5;
    private static final Color darkGreen = new Color(120, 170, 120);
    private static final Color selectedDarkGreen = new Color(120, 255, 120);
    private boolean selected;

    public JTag(String text) {
        super(text);
        this.init();
    }

    public JTag() {
        this.init();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        int w = this.getWidth() - 4;
        int h = this.getHeight() - 4;
        Graphics2D g = (Graphics2D)g2d;
        AffineTransform backup = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = darkGreen;
        if (this.selected) {
            color = selectedDarkGreen;
        }
        g.setColor(color);
        g.translate(2, 2);
        GeneralPath shape = new GeneralPath();
        shape.moveTo(w, h / 2);
        shape.lineTo(w - 6, h);
        shape.lineTo(5.0f, h);
        shape.quadTo(0.0f, h, 0.0f, h - 5);
        shape.lineTo(0.0f, 5.0f);
        shape.quadTo(0.0f, 0.0f, 5.0f, 0.0f);
        shape.lineTo(w - 6, 0.0f);
        shape.closePath();
        g.fill(shape);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(color.darker());
        g.draw(shape);
        g.setTransform(backup);
        super.paintComponent(g);
    }

    private void init() {
        this.setForeground(SystemColor.black);
        this.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
    }
}

