/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.slider;

import java.awt.Color;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;
import se.datadosen.jalbum.JAlbumColor;

public class SliderInfo
implements MouseMotionListener,
MouseListener {
    protected final JSlider slider;
    protected final JPopupMenu pop = new JPopupMenu();
    protected final JLabel item = new JLabel();
    private static final int Y_OFFSET = 28;

    public SliderInfo(JSlider slider) {
        this.slider = slider;
        this.init();
    }

    private void init() {
        this.slider.addMouseMotionListener(this);
        this.slider.addMouseListener(this);
        this.item.setBackground((Color)UIManager.getLookAndFeelDefaults().get("ToolTip.background"));
        this.item.setForeground((Color)UIManager.getLookAndFeelDefaults().get("ToolTip.foreground"));
        this.item.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.pop.setBorder(BorderFactory.createLineBorder(JAlbumColor.controlDkShadow, 1));
        this.item.setOpaque(true);
        this.pop.add(this.item);
        this.pop.setDoubleBuffered(false);
    }

    protected String getInfoText() {
        return "" + this.slider.getValue();
    }

    protected void showToolTip(MouseEvent me) {
        this.item.setText(this.getInfoText());
        int x = me.getX();
        if (!this.pop.isShowing()) {
            this.pop.show(me.getComponent(), x - 5, 28);
        } else {
            try {
                Point p = me.getComponent().getLocationOnScreen();
                p.translate((x - 5) / 10 * 10, 28);
                this.pop.setLocation(p);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.showToolTip(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.showToolTip(me);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.pop.setVisible(false);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }
}

