/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.search;

import java.awt.AWTException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.buttonbar.JButtonBarPane;
import se.datadosen.component.search.SearchSupport;
import se.datadosen.component.search.Target;
import se.datadosen.component.search.TargetProvider;
import se.datadosen.util.IO;
import se.datadosen.util.StringUtil;

public class UITarget
implements Target {
    private static final Set<String> units = new HashSet<String>(){
        {
            this.add("%");
            this.add("px");
            this.add("em");
            this.add("ms");
            this.add("s");
        }
    };
    private static final List<ContainerHandler> containerHandlers = new ArrayList<ContainerHandler>();
    private final JComponent comp;
    private final String path;
    private final List<Component> breadcrumbs;

    private static ContainerHandler findHandlerFor(Component comp) {
        for (ContainerHandler handler : containerHandlers) {
            if (!handler.getHandledClass().isAssignableFrom(comp.getClass())) continue;
            return handler;
        }
        return null;
    }

    public UITarget(JComponent comp, String path, List<Component> breadcrumbs) {
        this.comp = comp;
        this.path = path;
        this.breadcrumbs = breadcrumbs;
    }

    public UITarget(JComponent comp) {
        this.comp = comp;
        this.path = "";
        LinkedList<Component> bc = new LinkedList<Component>();
        for (Container c = comp; c != null; c = c.getParent()) {
            bc.addFirst(c);
        }
        this.breadcrumbs = bc;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public void open(InputEvent ie) {
        this.open(ie != null ? ie.getModifiersEx() : 0);
    }

    public void open(int modifiersEx) {
        if (this.toString().length() > 0) {
            // empty if block
        }
        for (int i = 0; i < this.breadcrumbs.size() - 1; ++i) {
            final ContainerHandler handler = UITarget.findHandlerFor(this.breadcrumbs.get(i));
            if (handler == null) continue;
            IndexedRunnable ir = new IndexedRunnable(this, i){
                final /* synthetic */ UITarget this$0;
                {
                    this.this$0 = this$0;
                    super(index);
                }

                @Override
                public void run() {
                    handler.show((Container)this.this$0.breadcrumbs.get(this.index), this.this$0.breadcrumbs.get(this.index + 1));
                }
            };
            SwingUtilities.invokeLater(ir);
        }
        this.comp.requestFocusInWindow();
        SearchSupport.animate(this.comp);
        if ((modifiersEx & 0x240) != 0) {
            new Thread(() -> {
                try {
                    File desktop;
                    Thread.sleep(1000L);
                    if (System.getProperty("desktop.path") != null && (desktop = new File(System.getProperty("desktop.path"))).exists()) {
                        Window win = SwingUtilities.getWindowAncestor(this.comp);
                        Rectangle screenRect = win.getBounds();
                        BufferedImage capture = new Robot().createScreenCapture(screenRect);
                        try {
                            ImageIO.write((RenderedImage)capture, "png", new File(desktop, IO.webSafe(this.path) + ".png"));
                        }
                        catch (IOException ex) {
                            ImageIO.write((RenderedImage)capture, "png", new File("jalbum-screenshot.png"));
                        }
                    }
                }
                catch (AWTException | IOException | InterruptedException ex) {
                    Logger.getLogger(UITarget.class.getName()).log(Level.SEVERE, null, ex);
                }
            }).start();
        }
    }

    private static String getTitle(Border border) {
        if (border instanceof TitledBorder) {
            return ((TitledBorder)border).getTitle();
        }
        if (border instanceof CompoundBorder) {
            String title = UITarget.getTitle(((CompoundBorder)border).getInsideBorder());
            if (title == null) {
                title = UITarget.getTitle(((CompoundBorder)border).getOutsideBorder());
            }
            return title;
        }
        return null;
    }

    static {
        containerHandlers.add(new ButtonBarPaneHandler());
        containerHandlers.add(new TabbedPaneHandler());
        containerHandlers.add(new CollapsiblePanelHandler());
        containerHandlers.add(new ScrollPaneHandler());
        containerHandlers.add(new PanelHandler());
        containerHandlers.add(new WindowHandler());
    }

    private static interface ContainerHandler {
        public Class getHandledClass();

        public void iterate(Container var1, BiConsumer<Component, String> var2);

        public void show(Container var1, Component var2);
    }

    private static class ButtonBarPaneHandler
    implements ContainerHandler {
        private ButtonBarPaneHandler() {
        }

        @Override
        public Class getHandledClass() {
            return JButtonBarPane.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            JButtonBarPane bar = (JButtonBarPane)c;
            for (int i = 0; i < bar.getTabHolder().getComponentCount(); ++i) {
                childHandler.accept(bar.getTabHolder().getComponent(i), ((AbstractButton)bar.getButtonBar().getComponent(i)).getText());
            }
        }

        @Override
        public void show(Container c, Component child) {
            JButtonBarPane bar = (JButtonBarPane)c;
            if (child.getName() != null) {
                bar.show(child);
            }
        }
    }

    private static class TabbedPaneHandler
    implements ContainerHandler {
        private TabbedPaneHandler() {
        }

        @Override
        public Class getHandledClass() {
            return JTabbedPane.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            JTabbedPane tp = (JTabbedPane)c;
            for (int i = 0; i < tp.getTabCount(); ++i) {
                childHandler.accept(tp.getComponentAt(i), tp.getTitleAt(i));
            }
        }

        @Override
        public void show(Container c, Component child) {
            JTabbedPane tp = (JTabbedPane)c;
            tp.setSelectedComponent(child);
        }
    }

    private static class CollapsiblePanelHandler
    implements ContainerHandler {
        private CollapsiblePanelHandler() {
        }

        @Override
        public Class getHandledClass() {
            return JCollapsiblePanel.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            JCollapsiblePanel panel = (JCollapsiblePanel)c;
            childHandler.accept(panel.getContentPanel(), panel.getTitle());
        }

        @Override
        public void show(Container c, Component child) {
            JCollapsiblePanel panel = (JCollapsiblePanel)c;
            panel.setExpanded(true);
        }
    }

    private static class ScrollPaneHandler
    implements ContainerHandler {
        private ScrollPaneHandler() {
        }

        @Override
        public Class getHandledClass() {
            return JScrollPane.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            JScrollPane scrollPane = (JScrollPane)c;
            childHandler.accept(scrollPane.getViewport().getView(), UITarget.getTitle(scrollPane.getBorder()));
        }

        @Override
        public void show(Container c, Component child) {
        }
    }

    private static class PanelHandler
    implements ContainerHandler {
        private PanelHandler() {
        }

        @Override
        public Class getHandledClass() {
            return JPanel.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            Component[] comps = c.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                childHandler.accept(comps[i], UITarget.getTitle(((JPanel)c).getBorder()));
            }
        }

        @Override
        public void show(Container c, Component child) {
        }
    }

    private static class WindowHandler
    implements ContainerHandler {
        private WindowHandler() {
        }

        @Override
        public Class getHandledClass() {
            return Window.class;
        }

        @Override
        public void iterate(Container c, BiConsumer<Component, String> childHandler) {
            if (c instanceof JFrame) {
                JFrame win = (JFrame)c;
                childHandler.accept(win.getContentPane(), win.getTitle());
            } else if (c instanceof JDialog) {
                JDialog win = (JDialog)c;
                childHandler.accept(win.getContentPane(), win.getTitle());
            }
        }

        @Override
        public void show(Container c, Component child) {
            if (c instanceof Window) {
                if (!c.isVisible()) {
                    ((Window)c).pack();
                    c.setVisible(true);
                } else {
                    ((Window)c).toFront();
                }
            }
        }
    }

    private static abstract class IndexedRunnable
    implements Runnable {
        protected int index;

        public IndexedRunnable(int index) {
            this.index = index;
        }
    }

    public static class Provider
    implements TargetProvider {
        private Container root;
        private List<Target> allTargets;
        private Set<String> uniquePaths;

        public Provider(Container root) {
            this.root = root;
        }

        @Override
        public Stream<Target> getTargets() {
            this.allTargets = new ArrayList<Target>();
            this.uniquePaths = new HashSet<String>();
            this.initTargets(new ArrayList<Component>(), this.root, "");
            return this.allTargets.stream();
        }

        private void addUniqueTarget(UITarget target) {
            if (!this.uniquePaths.contains(target.path)) {
                this.allTargets.add(target);
                this.uniquePaths.add(target.path);
            }
        }

        private void initTargets(List<Component> breadcrumbs, Container parent, String path) {
            ContainerHandler handler;
            ArrayList<Component> bc = new ArrayList<Component>(breadcrumbs);
            bc.add(parent);
            if (parent instanceof JComponent) {
                Container grandParent = parent.getParent();
                if (!(parent.isVisible() || grandParent instanceof JCollapsiblePanel || grandParent instanceof JTabbedPane || grandParent.getLayout() instanceof CardLayout)) {
                    return;
                }
                this.addUniqueTarget(new UITarget((JComponent)parent, path, bc));
            }
            if ((handler = UITarget.findHandlerFor(parent)) != null) {
                handler.iterate(parent, (child, title) -> this.initTargets(bc, (Container)child, (String)(title != null ? (String)(path.length() > 0 ? path + " - " : "") + StringUtil.stripTags(title).trim() : path)));
            } else {
                String text = null;
                if (parent instanceof AbstractButton) {
                    text = ((AbstractButton)parent).getText();
                } else if (parent instanceof JLabel) {
                    text = ((JLabel)parent).getText();
                } else if (parent instanceof JComboBox || parent instanceof JSpinner) {
                    return;
                }
                if (text != null && text.length() > 0) {
                    if (!((text = StringUtil.limit(StringUtil.stripTags(text).trim(), 40)).length() <= 0 || text.length() <= 3 && units.contains(text))) {
                        String finalPath = (String)(path.length() > 0 ? path + " - " : "") + text;
                        if (parent instanceof JLabel && ((JLabel)parent).getLabelFor() != null) {
                            parent = (Container)((JLabel)parent).getLabelFor();
                        }
                        this.addUniqueTarget(new UITarget((JComponent)parent, finalPath, bc));
                    }
                } else {
                    for (Component comp : parent.getComponents()) {
                        this.initTargets(bc, (Container)comp, path);
                    }
                }
            }
        }
    }
}

