/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.search;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.jalbum.UsageCounters;
import se.datadosen.component.JWorkFlow;
import se.datadosen.component.JWorkFlowStep;
import se.datadosen.component.MenuBasedAutoCompleter;
import se.datadosen.component.search.Target;
import se.datadosen.component.search.TargetProvider;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;

public class SearchSupport
extends MenuBasedAutoCompleter<Target> {
    public static final String USAGE_KEY = "searchSupport";
    private List<TargetProvider> providers = new ArrayList<TargetProvider>();
    private final List<Target> targets = new ArrayList<Target>();
    private AtomicLong counter;
    Thread targetAdder;

    static void animate(JComponent comp) {
        JWorkFlow workFlow = new JWorkFlow(comp);
        workFlow.addStep(new JWorkFlowStep(0, comp));
        workFlow.install(SwingUtilities.getWindowAncestor(comp));
        workFlow.setRepeat(false);
        workFlow.setAnimate(true);
    }

    public SearchSupport(final JTextComponent textComp, TargetProvider ... providers) {
        super(textComp);
        this.providers.addAll(Arrays.asList(providers));
        textComp.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ SearchSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusGained(FocusEvent e) {
                textComp.selectAll();
                this.this$0.addTargets();
                JAlbumUtilities.schedule(() -> SwingUtilities.invokeLater(() -> this.this$0.showPopup()), 200L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.this$0.targets.clear();
            }
        });
    }

    public void addProvider(TargetProvider provider) {
        this.providers.add(provider);
    }

    public void removeProvider(TargetProvider provider) {
        this.providers.remove(provider);
    }

    public List<TargetProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<TargetProvider> providers) {
        this.providers = providers;
    }

    private void addTargets() {
        JAlbumFrame window = JAlbumContext.getInstance().getFrame();
        this.targetAdder = new Thread(() -> {
            Stream<Target> targetStream = this.providers.get(0).getTargets();
            for (int i = 1; i < this.providers.size(); ++i) {
                targetStream = Stream.concat(targetStream, this.providers.get(i).getTargets());
            }
            this.counter = new AtomicLong(0L);
            float javaSpec = Float.parseFloat(System.getProperty("java.specification.version"));
            if (javaSpec >= 9.0f) {
                targetStream = targetStream.takeWhile(t -> this.textComp.isShowing() && this.textComp.hasFocus());
            }
            this.targets.clear();
            AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());
            try {
                window.progressSpinner.workStarted();
                targetStream.peek(t -> {
                    if (this.counter.incrementAndGet() % 1000L == 0L) {
                        window.statusBar.setText(Msg.get("search.indexing", this.counter));
                    }
                    if (System.currentTimeMillis() - lastTime.get() > 1000L) {
                        if (this.list.getVisibleRowCount() < 5) {
                            SwingUtilities.invokeLater(() -> {
                                if (this.popup.isShowing()) {
                                    this.showPopup();
                                }
                            });
                        } else {
                            this.updateListData();
                        }
                        lastTime.set(System.currentTimeMillis());
                    }
                }).forEach(t -> {
                    List<Target> list = this.targets;
                    synchronized (list) {
                        this.targets.add((Target)t);
                    }
                });
                SwingUtilities.invokeLater(() -> {
                    if (this.popup.isShowing()) {
                        this.showPopup();
                    }
                });
            }
            finally {
                window.progressSpinner.workDone();
                window.statusBar.setText("");
            }
        }, "Search indexer");
        this.targetAdder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateListData() {
        String search = this.textComp.getText().toLowerCase();
        String[] tokens = search.split(" ");
        if (search.length() > 1) {
            int selIndex = this.list.getSelectedIndex();
            List<Target> list = this.targets;
            synchronized (list) {
                Target[] listData = (Target[])this.targets.stream().filter(p -> {
                    String lcPath = p.getPath().toLowerCase();
                    for (String token : tokens) {
                        if (lcPath.contains(token)) continue;
                        return false;
                    }
                    return true;
                }).toArray(Target[]::new);
                this.list.setListData(listData);
                this.list.setSelectedIndex(selIndex);
            }
        } else {
            this.list.setListData(new Target[0]);
        }
        return true;
    }

    @Override
    protected void acceptedListItem(InputEvent ie, Target selected) {
        UsageCounters.increase(USAGE_KEY);
        selected.open(ie);
        this.textComp.selectAll();
        if ((ie.getModifiersEx() & 0x240) != 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(selected.toString()), null);
        }
    }
}

