/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.search;

import java.awt.event.InputEvent;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import se.datadosen.component.search.Target;
import se.datadosen.component.search.TargetProvider;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;

public class ProjectTarget
implements Target {
    private final String path;
    private final AlbumProject albumProject;
    private final ProjectGroup projectGroup;

    public ProjectTarget(AlbumProject ap, ProjectGroup pg) {
        this.albumProject = ap;
        this.projectGroup = pg;
        this.path = Msg.get("ui.projects") + " - " + ap.getLongName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.albumProject);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectTarget other = (ProjectTarget)obj;
        return Objects.equals(this.albumProject, other.albumProject);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public void open(InputEvent ie) {
        if (ProjectGroups.getInstance().getCurrentGroup() != ProjectGroup.RECENT_PROJECTS_GROUP) {
            ProjectGroups.getInstance().setCurrentGroup(this.projectGroup);
        }
        SwingUtilities.invokeLater(() -> JAlbumContext.getInstance().getFrame().loadProject(this.albumProject.getProjectFile()));
    }

    public static class Provider
    implements TargetProvider {
        @Override
        public Stream<Target> getTargets() {
            HashSet projects = new HashSet();
            ProjectGroups.getInstance().groups().forEach(pg -> {
                for (AlbumProject ap : pg.getProjects()) {
                    ProjectTarget target = new ProjectTarget(ap, (ProjectGroup)pg);
                    projects.remove(target);
                    projects.add(target);
                }
            });
            return (Stream)projects.stream().sorted().unordered();
        }
    }
}

