/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.search;

import java.awt.event.InputEvent;
import java.util.stream.Stream;
import se.datadosen.component.search.Target;
import se.datadosen.component.search.TargetProvider;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.StringUtil;

public class AlbumObjectTarget
implements Target {
    private String path;
    private String visiblePath;
    private final AlbumObject ao;

    private AlbumObjectTarget(AlbumObject ao, boolean indexMetadata, String prefix) {
        this.ao = ao;
        this.visiblePath = this.path = prefix + ao.getPathFromRoot();
        if (indexMetadata) {
            String title = ao.getTitle();
            String comment = ao.getComment();
            String keywords = ao.getKeywords();
            String meta = StringUtil.concat("|", title, comment, keywords);
            this.visiblePath = this.visiblePath + ": " + this.trim(meta);
            this.path = this.path + ": " + meta;
        }
    }

    String trim(String text) {
        return StringUtil.limit(StringUtil.stripTags(text).trim(), 60);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.visiblePath;
    }

    @Override
    public void open(InputEvent ie) {
        JAlbumExplorer albumExplorer = JAlbumContext.getInstance().getFrame().albumExplorer;
        albumExplorer.gotoPath(this.ao.getPathFromRoot());
    }

    public static class Provider
    implements TargetProvider {
        @Override
        public Stream<Target> getTargets() {
            AlbumObject currentFolder = JAlbumContext.getInstance().getFrame().albumExplorer.getCurrentFolder();
            String prefix = Msg.get("ui.currentProject") + " - ";
            if (currentFolder.getChildren(false) != null) {
                boolean indexMetadata = Config.getConfig().isIndexMetadata();
                Stream<Object> stream = currentFolder.getDescendants(IncludeOption.EXCLUDED, IncludeOption.HIDDEN).filter(ao -> !ao.isUnderView()).parallelStream();
                if (Config.getConfig().isIndexMetadata()) {
                    stream = stream.peek(ao -> ao.getXmpManager());
                }
                return stream.map(ao -> new AlbumObjectTarget((AlbumObject)ao, indexMetadata, prefix));
            }
            return Stream.empty();
        }
    }
}

