/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.mac;

import ca.weblite.objc.NSObject;
import ca.weblite.objc.Proxy;
import ca.weblite.objc.RuntimeUtils;
import ca.weblite.objc.util.CocoaUtils;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class NativeFileDialog
extends NSObject {
    private Proxy peer;
    private int mode;
    private long result;

    public NativeFileDialog(String title, int mode) {
        super("NSObject");
        this.mode = mode;
        CocoaUtils.dispatch_sync(() -> {
            this.peer = mode == 0 ? this.getClient().sendProxy("NSOpenPanel", "openPanel", new Object[0]) : this.getClient().sendProxy("NSSavePanel", "savePanel", new Object[0]);
            this.peer.send("setTitle:", new Object[]{title});
            this.peer.send("retain", new Object[0]);
        });
    }

    private void set(String selector, String value) {
        CocoaUtils.dispatch_sync(() -> {
            if (this.peer.getPeer().equals((Object)Pointer.NULL)) {
                throw new RuntimeException("The peer is null");
            }
            this.peer.send(RuntimeUtils.sel((String)selector), new Object[]{value});
        });
    }

    private void set(String selector, int value) {
        CocoaUtils.dispatch_sync(() -> this.peer.send(selector, new Object[]{value}));
    }

    private String getString(String selector) {
        String[] out = new String[1];
        CocoaUtils.dispatch_sync(() -> {
            out[0] = this.peer.sendString(selector, new Object[0]);
        });
        return out[0];
    }

    private int getI(String selector) {
        int[] out = new int[1];
        CocoaUtils.dispatch_sync(() -> {
            out[0] = this.peer.sendInt(RuntimeUtils.sel((String)selector), new Object[0]);
        });
        return out[0];
    }

    public void setTitle(String title) {
        this.set("setTitle:", title);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public void setPrompt(String prompt) {
        this.set("setPrompt:", prompt);
    }

    public void setNameFieldLabel(String label) {
        this.set("setNameFieldLabel:", label);
    }

    public String getNameFieldLabel() {
        return this.getString("nameFieldLabel");
    }

    public void setMessage(String message) {
        this.set("setMessage:", message);
    }

    public String getMessage() {
        return this.getString("message");
    }

    public String getPrompt() {
        return this.getString("prompt");
    }

    public boolean canCreateDirectories() {
        return this.getI("canCreateDirectories") != 0;
    }

    public void setCanCreateDirectories(boolean can) {
        this.set("setCanCreateDirectories:", can ? 1 : 0);
    }

    public boolean showsHiddenFiles() {
        return this.getI("showsHiddenFiles") != 0;
    }

    public void setShowsHiddenFiles(boolean shows) {
        this.set("setShowsHiddenFiles:", shows ? 1 : 0);
    }

    public boolean isExtensionHidden() {
        return this.getI("isExtensionHidden") != 0;
    }

    public void setExtensionHidden(boolean hidden) {
        this.set("setExtensionHidden:", hidden ? 1 : 0);
    }

    public boolean canSelectHiddenExtension() {
        return this.getI("canSelectHiddenExtension") != 0;
    }

    public void setCanSelectHiddenExtension(boolean sel) {
        this.set("setCanSelectHiddenExtension:", sel ? 1 : 0);
    }

    public void setNameFieldStringValue(String val) {
        this.set("setNameFieldStringValue:", val);
    }

    public List<String> getAllowedFileTypes() {
        ArrayList<String> out = new ArrayList<String>();
        CocoaUtils.dispatch_sync(() -> {
            Proxy types = this.peer.sendProxy("allowedFileTypes", new Object[0]);
            int size = types.getInt("count");
            for (int i = 0; i < size; ++i) {
                String nex = types.sendString("objectAtIndex:", new Object[]{i});
                out.add(nex);
            }
        });
        return out;
    }

    public void setAllowedFileTypes(List<String> types) {
        CocoaUtils.dispatch_sync(() -> {
            Proxy mutableArray = this.getClient().sendProxy("NSMutableArray", "arrayWithCapacity:", new Object[]{types.size()});
            for (String type : types) {
                mutableArray.send("addObject:", new Object[]{type});
            }
            this.peer.send("setAllowedFileTypes:", new Object[]{mutableArray});
        });
    }

    public boolean allowsOtherFileTypes() {
        return this.getI("allowsOtherFileTypes") != 0;
    }

    public void setAllowsOtherFileTypes(boolean allowed) {
        this.set("setAllowsOtherFileTypes:", allowed ? 1 : 0);
    }

    public boolean getTreatsFilePackagesAsDirectories() {
        return this.getI("treatsFilePackagesAsDirectories") != 0;
    }

    public void setTreatsFilePackagesAsDirectories(boolean treat) {
        this.set("setTreatsFilePackagesAsDirectories:", treat ? 1 : 0);
    }

    public String getDirectory() {
        String[] out = new String[1];
        CocoaUtils.dispatch_sync(() -> {
            Proxy dirUrl = this.peer.sendProxy("directoryURL", new Object[0]);
            out[0] = dirUrl.getPeer().equals((Object)Pointer.NULL) ? null : dirUrl.sendString("path", new Object[0]);
        });
        return out[0];
    }

    public String getFile() {
        String[] out = new String[1];
        CocoaUtils.dispatch_sync(() -> {
            Proxy fileUrl = this.peer.sendProxy("URL", new Object[0]);
            if (fileUrl == null || fileUrl.getPeer().equals((Object)Pointer.NULL)) {
                out[0] = null;
            } else {
                long p = RuntimeUtils.msg((Pointer)fileUrl.getPeer(), (String)"path", (Object[])new Object[0]);
                String path = RuntimeUtils.msgString((Pointer)new Pointer(p), (String)"UTF8String", (Object[])new Object[0]);
                out[0] = fileUrl.sendString("path", new Object[0]);
            }
        });
        return out[0];
    }

    public File[] getFiles() {
        ArrayList out = new ArrayList();
        CocoaUtils.dispatch_sync(() -> {
            Proxy nsArray;
            if (this.mode == 0 && !(nsArray = this.peer.getProxy("URLs")).getPeer().equals((Object)Pointer.NULL)) {
                int size = nsArray.sendInt("count", new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Proxy url = nsArray.sendProxy("objectAtIndex:", new Object[]{i});
                    String path = url.sendString("path", new Object[0]);
                    out.add(new File(path));
                }
            }
        });
        return out.toArray(new File[out.size()]);
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleMode() {
        return this.getI("allowsMultipleSelection") != 0;
    }

    public void setMultipleMode(boolean enable) {
        this.set("setAllowsMultipleSelection:", enable ? 1 : 0);
    }

    public boolean canChooseFiles() {
        return this.getI("canChooseFiles") != 0;
    }

    public void setCanChooseFiles(boolean can) {
        this.set("setCanChooseFiles:", can ? 1 : 0);
    }

    public boolean getCanChooseDirectories() {
        return this.getI("canChooseDirectories") != 0;
    }

    public void setCanChooseDirectories(boolean can) {
        this.set("setCanChooseDirectories:", can ? 1 : 0);
    }

    public boolean getResolvesAliases() {
        return this.getI("resolvesAliases") != 0;
    }

    public void setResolvesAliases(boolean resolves) {
        this.set("setResolvesAliases:", resolves ? 1 : 0);
    }

    public void setDirectory(String dir) {
        CocoaUtils.dispatch_sync(() -> {
            Proxy url = this.getClient().sendProxy("NSURL", "fileURLWithPath:isDirectory:", new Object[]{dir, 1});
            this.peer.send("setDirectoryURL:", new Object[]{url.getPeer()});
        });
    }

    public void setFile(String file) {
        throw new UnsupportedOperationException("setFile() notimplemented");
    }

    public void setMode(int mode) {
        throw new UnsupportedOperationException("Can't set mode after initialization");
    }

    public int getResult() {
        return (int)this.result;
    }

    public void setVisible(boolean visible) {
        CocoaUtils.dispatch_sync(() -> {
            this.result = (Long)this.peer.send("runModal", new Object[0]);
        });
    }

    public static void main(String[] args) {
        NativeFileDialog dlg = new NativeFileDialog("Foo", 1);
        dlg.setTitle("bar");
        dlg.setPrompt("The prompt");
        dlg.setMessage("The message");
        dlg.setCanCreateDirectories(true);
        dlg.setAllowedFileTypes(Arrays.asList("zip"));
        dlg.setVisible(true);
    }
}

