/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.mac;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;
import se.datadosen.component.mac.NativeFileDialog;

public class MacFileChooser
implements FileChooser {
    private final NativeFileDialog dlg = new NativeFileDialog("", 0);
    private ActionListener listener;
    private final List<String> allowedTypes = new ArrayList<String>();
    final EventQueue eventQueue;
    SecondaryLoop loop;
    int retVal;

    public MacFileChooser() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.eventQueue = tk.getSystemEventQueue();
    }

    @Override
    public void setDialogType(int dialogType) {
        if (dialogType == 1) {
            throw new UnsupportedOperationException("Save type currently not supported");
        }
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        this.dlg.setMultipleMode(b);
    }

    @Override
    public void setFileSelectionMode(int mode) {
        switch (mode) {
            case 0: {
                this.dlg.setCanChooseDirectories(false);
                this.dlg.setCanChooseFiles(true);
                break;
            }
            case 1: {
                this.dlg.setCanChooseDirectories(true);
                this.dlg.setCanChooseFiles(false);
                break;
            }
            case 2: {
                this.dlg.setCanChooseDirectories(true);
                this.dlg.setCanChooseFiles(true);
            }
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    @Override
    public void setFileView(FileView fileView) {
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        if (!(filter instanceof FileNameExtensionFilter)) {
            throw new IllegalArgumentException("filter is not a FileNameExtensionFilter");
        }
        FileNameExtensionFilter extFilter = (FileNameExtensionFilter)filter;
        for (String ext : extFilter.getExtensions()) {
            this.allowedTypes.add(ext);
        }
        this.dlg.setAllowedFileTypes(this.allowedTypes);
    }

    @Override
    public File[] getSelectedFiles() {
        return this.dlg.getFiles();
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dlg.setDirectory(dir != null ? dir.getAbsolutePath() : null);
    }

    @Override
    public File getCurrentDirectory() {
        String dir = this.dlg.getDirectory();
        return dir != null ? new File(dir) : null;
    }

    @Override
    public void setSelectedFile(File file) {
    }

    @Override
    public File getSelectedFile() {
        String path = this.dlg.getFile();
        return path != null ? new File(path) : null;
    }

    @Override
    public void setDialogTitle(String title) {
        this.dlg.setTitle(title);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.loop = this.eventQueue.createSecondaryLoop();
        new Thread(() -> {
            try {
                this.dlg.setVisible(true);
                if (this.dlg.getResult() == 1) {
                    if (this.listener != null) {
                        this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
                    }
                    this.retVal = 0;
                } else {
                    this.retVal = 1;
                }
            }
            finally {
                this.loop.exit();
            }
        }, "File chooser thread").start();
        this.loop.enter();
        return this.retVal;
    }

    @Override
    public int showOpenDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

