/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Cursor;
import java.awt.Window;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;

public class WaitCursor {
    private final Window parent;
    private long delay = 200L;
    private int nWorkers = 0;
    private ScheduledFuture pendingWaitCursor;

    public WaitCursor(Window parent) {
        this.parent = parent;
    }

    public WaitCursor(Window parent, long delay) {
        this.parent = parent;
        this.delay = delay;
    }

    public WaitToken getToken() {
        return new WaitToken(this);
    }

    public void workStarted() {
        ++this.nWorkers;
        if (this.pendingWaitCursor == null || this.pendingWaitCursor.isDone() || this.pendingWaitCursor.isCancelled()) {
            this.pendingWaitCursor = JAlbumUtilities.schedule(() -> this.parent.setCursor(Cursor.getPredefinedCursor(3)), this.delay, TimeUnit.MILLISECONDS);
        }
    }

    public void workDone() {
        --this.nWorkers;
        if (this.nWorkers < 0) {
            this.nWorkers = 0;
        }
        if (this.nWorkers == 0) {
            if (this.pendingWaitCursor != null) {
                this.pendingWaitCursor.cancel(false);
            }
            this.parent.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static class WaitToken
    implements AutoCloseable {
        private final WaitCursor waitCursor;

        public WaitToken(JComponent callerComp) {
            this.waitCursor = JAlbumContext.getInstance().getFrame().waitCursor;
            this.waitCursor.workStarted();
        }

        public WaitToken(WaitCursor waitCursor) {
            this.waitCursor = waitCursor;
            waitCursor.workStarted();
        }

        @Override
        public void close() {
            this.waitCursor.workDone();
        }
    }
}

