/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;

public class VerticalLayout
implements LayoutManager,
Serializable {
    protected int vgap = 4;

    public VerticalLayout() {
    }

    public VerticalLayout(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets in = target.getInsets();
            Component[] comps = target.getComponents();
            if (comps.length == 0) {
                return new Dimension(in.right + in.left, in.bottom + in.top);
            }
            int y = 0;
            for (Component c : comps) {
                if (!c.isVisible()) continue;
                y += c.getPreferredSize().height + this.vgap;
            }
            Component last = comps[comps.length - 1];
            Rectangle lastBounds = last.getBounds();
            return new Dimension(lastBounds.x + last.getPreferredSize().width + in.right, (y -= this.vgap) + in.bottom + in.top);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets in = target.getInsets();
            int y = in.top;
            int width = target.getWidth() - in.right - in.left;
            for (Component comp : target.getComponents()) {
                if (!comp.isVisible()) continue;
                comp.setLocation(in.left, y);
                Dimension pref = comp.getPreferredSize();
                comp.setSize(pref.width, pref.height);
                comp.setSize(width, comp.getHeight());
                y += comp.getHeight();
                y += this.vgap;
            }
        }
    }
}

