/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import se.datadosen.jalbum.JAlbumColor;

public class Verifier {
    private JTextComponent comp;
    Consumer<String> verifier;

    public Verifier(JTextComponent comp) {
        this.comp = comp;
        this.init();
    }

    public void onVerify(Consumer<String> verifier) {
        this.verifier = verifier;
    }

    public void verify() {
        if (this.verifier != null) {
            new Thread(() -> this.verifier.accept(this.comp.getText())).start();
        }
    }

    public void setUnverified() {
        this.comp.setForeground(this.comp.isEnabled() ? JAlbumColor.textText : JAlbumColor.textInactiveText);
    }

    public void setVerified(boolean ok) {
        this.comp.setForeground(ok ? Color.green.darker() : new Color(255, 50, 50));
    }

    private void init() {
        this.comp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Verifier.this.setUnverified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Verifier.this.setUnverified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Verifier.this.setUnverified();
            }
        });
        this.comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Verifier.this.setUnverified();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Verifier.this.verify();
            }
        });
    }
}

