/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.JColorSelector;
import se.datadosen.util.BeanBinder;

public abstract class StateMonitor
implements ItemListener,
DocumentListener,
PropertyChangeListener,
ChangeListener,
ListDataListener {
    protected Object source;

    public StateMonitor() {
    }

    public StateMonitor(JComponent ... comps) {
        this.add(comps);
    }

    public StateMonitor(ComboBoxModel model) {
        this.add(model);
    }

    public StateMonitor add(JCheckBox comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JRadioButton comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JComboBox comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JSpinner comp) {
        comp.addChangeListener(this);
        return this;
    }

    public StateMonitor add(JSlider comp) {
        comp.addChangeListener(this);
        return this;
    }

    public StateMonitor add(JTextComponent comp) {
        comp.getDocument().addDocumentListener(this);
        return this;
    }

    public StateMonitor add(JColorSelector comp) {
        comp.addPropertyChangeListener("color", this);
        return this;
    }

    public StateMonitor add(ComboBoxModel model) {
        model.addListDataListener(this);
        return this;
    }

    public StateMonitor add(JList list) {
        list.getModel().addListDataListener(this);
        return this;
    }

    public StateMonitor add(ListModel listModel) {
        listModel.addListDataListener(this);
        return this;
    }

    public StateMonitor add(JComponent ... comps) {
        for (JComponent comp : comps) {
            if (comp instanceof JCheckBox) {
                this.add((JCheckBox)comp);
                continue;
            }
            if (comp instanceof JRadioButton) {
                this.add((JRadioButton)comp);
                continue;
            }
            if (comp instanceof JComboBox) {
                this.add((JComboBox)comp);
                continue;
            }
            if (comp instanceof JSpinner) {
                this.add((JSpinner)comp);
                continue;
            }
            if (comp instanceof JTextComponent) {
                this.add((JTextComponent)comp);
                continue;
            }
            if (comp instanceof JColorSelector) {
                this.add((JColorSelector)comp);
                continue;
            }
            if (comp instanceof JSlider) {
                this.add((JSlider)comp);
                continue;
            }
            if (comp instanceof JList) {
                this.add((JList)comp);
                continue;
            }
            if (comp instanceof ListModel) {
                this.add((ListModel)((Object)comp));
                continue;
            }
            throw new IllegalArgumentException(comp.getClass().getName() + " not an allowed component");
        }
        return this;
    }

    public Object getSource() {
        return this.source;
    }

    public abstract void onChange();

    public void done() {
        this.onChange();
    }

    public static void enable(boolean test, JComponent comp) {
        StateMonitor.enable(test, new JComponent[]{comp});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2, comp3});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3, JComponent comp4) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2, comp3, comp3, comp4});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3, JComponent comp4, JComponent comp5) {
        StateMonitor.enable(test, comp1, comp2, comp3, comp3, comp4, comp5);
    }

    public static void enable(boolean test, JComponent ... comps) {
        for (JComponent comp : comps) {
            if (ComponentUtilities.isEnabledVetoed(comp)) continue;
            comp.setEnabled(test);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!(e.getSource() instanceof JComboBox) || e.getStateChange() == 1) {
            this.source = e.getSource();
            this.onChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    public static StateMonitorImpl monitoring(JComponent ... comps) {
        StateMonitorImpl monitor = new StateMonitorImpl();
        monitor.add(comps);
        return monitor;
    }

    public static class StateMonitorImpl
    extends StateMonitor {
        private Consumer action;

        private StateMonitorImpl() {
        }

        public void onChange(Consumer action) {
            this.action = action;
            this.done();
        }

        public void onUserChange(Consumer action) {
            this.action = t -> {
                if (!BeanBinder.isSynchingUI()) {
                    action.accept(this.source);
                }
            };
        }

        @Override
        public void onChange() {
            if (this.action == null) {
                throw new IllegalStateException("No onChange action set");
            }
            this.action.accept(this.source);
        }
    }
}

