/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

class SpriteIcon
extends ImageIcon {
    private static final Map<URL, BufferedImage> imageCache = new HashMap<URL, BufferedImage>();
    protected int xOffset = 0;
    protected int yOffset = 0;

    public static synchronized ImageIcon createFromSprite(URL location, int xIndex, int yIndex) throws IOException {
        BufferedImage sprite = imageCache.get(location);
        if (sprite == null) {
            sprite = ImageIO.read(location);
            imageCache.put(location, sprite);
        }
        int size = Math.min(sprite.getWidth(), sprite.getHeight());
        int type = sprite.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage bi = new BufferedImage(size, size, type);
        Graphics g = bi.getGraphics();
        g.drawImage(sprite, 0, 0, size, size, xIndex * size, yIndex * size, xIndex * size + size, yIndex * size + size, null);
        return new ImageIcon(bi);
    }

    public SpriteIcon(URL location) {
        super(location);
    }

    @Override
    protected void loadImage(Image image) {
        super.loadImage(image);
    }

    @Override
    public int getIconHeight() {
        int width = super.getIconWidth();
        int height = super.getIconHeight();
        return Math.min(width, height);
    }

    @Override
    public int getIconWidth() {
        return this.getIconHeight();
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.getImageObserver() == null) {
            g.drawImage(this.getImage(), x, y, x + this.getIconWidth(), y + this.getIconHeight(), this.xOffset, this.yOffset, this.xOffset + this.getIconWidth(), this.yOffset + this.getIconHeight(), c);
        } else {
            g.drawImage(this.getImage(), x, y, x + this.getIconWidth(), y + this.getIconHeight(), this.xOffset, this.yOffset, this.xOffset + this.getIconWidth(), this.yOffset + this.getIconHeight(), this.getImageObserver());
        }
    }
}

