/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import com.inet.jortho.SpellChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import se.datadosen.component.JHtmlEditor;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.AliasAction;

public class SmartTextComponentSupport
implements UndoableEditListener,
MouseListener {
    static Icon undoIcon = Icons.small("undo");
    static Icon redoIcon = Icons.small("redo");
    static Icon cutIcon = Icons.small("cut");
    static Icon copyIcon = Icons.small("copy");
    static Icon pasteIcon = Icons.small("paste");
    static Icon removeSelectionIcon = Icons.small("delete");
    static Icon selectAllIcon = Icons.small("select");
    public static final int NO_SELECTION = 0;
    public static final int SOME_SELECTED = 1;
    public static final int ALL_SELECTED = 2;
    public static final int UNDO_LIMIT = 1500;
    JTextComponent comp;
    private UndoManager undoManager;
    private MenuContext menuContext;
    private boolean allowHTMLEditing;
    private boolean fullHTMLEditing;
    private Box buttonBox;
    private static Box currentButtonBox;
    private static JTextComponent currentComponent;
    private final Action openHtmlEditorAction = new AbstractAction(Msg.get("ui.openHTMLEditor"), Icons.small("edit-html")){
        {
            this.putValue("ShortDescription", Msg.get("ui.openHTMLEditor"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String oldText = SmartTextComponentSupport.this.comp.getText();
            SmartTextComponentSupport.this.comp.requestFocusInWindow();
            String result = JHtmlEditor.showEditor(SmartTextComponentSupport.this.comp, oldText, SmartTextComponentSupport.this.fullHTMLEditing || (e.getModifiers() & 0x240) != 0);
            if (result != null) {
                SmartTextComponentSupport.this.comp.setText(result);
            }
        }
    };
    Action undoAction = new AbstractAction(Msg.get("edit.undo"), undoIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SmartTextComponentSupport.this.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    };
    Action redoAction = new AbstractAction(Msg.get("edit.redo"), redoIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SmartTextComponentSupport.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    };
    AliasAction cutAction = new AliasAction(null, Msg.get("edit.cut"), Icons.small("cut"));
    AliasAction copyAction = new AliasAction(null, Msg.get("edit.copy"), Icons.small("copy"));
    Action pasteAction = new AbstractAction(Msg.get("edit.paste"), pasteIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = clipboard.getContents(SmartTextComponentSupport.this.comp);
            try {
                String content = (String)t.getTransferData(DataFlavor.stringFlavor);
                int start = SmartTextComponentSupport.this.comp.getSelectionStart();
                int end = SmartTextComponentSupport.this.comp.getSelectionEnd();
                Document doc = SmartTextComponentSupport.this.comp.getDocument();
                doc.remove(start, end - start);
                doc.insertString(start, content, null);
                Consumer onPaste = (Consumer)SmartTextComponentSupport.this.comp.getClientProperty("onPaste");
                if (onPaste != null) {
                    onPaste.accept(content);
                }
            }
            catch (UnsupportedFlavorException | IOException | BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    };
    private final PropertyChangeListener spellingPreferenceListener = pce -> {
        boolean active = (Boolean)pce.getNewValue();
        if (active) {
            this.menuContext = null;
            SpellChecker.register((JTextComponent)this.comp, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
        } else {
            this.menuContext = null;
            SpellChecker.unregister((JTextComponent)this.comp);
        }
    };

    public static JTextComponent getCurrentComponent() {
        return currentComponent;
    }

    public boolean isAllowHTMLEditing() {
        return this.allowHTMLEditing;
    }

    public void setAllowHTMLEditing(boolean allowHTMLEditing) {
        if (allowHTMLEditing && !this.allowHTMLEditing && Config.getConfig().isShowOpenHTMLEditorButton()) {
            this.installHoverButton(this.openHtmlEditorAction);
        }
        this.allowHTMLEditing = allowHTMLEditing;
    }

    public boolean isFullHTMLEditing() {
        return this.fullHTMLEditing;
    }

    public void setFullHTMLEditing(boolean fullHTMLEditing) {
        if (fullHTMLEditing) {
            this.setAllowHTMLEditing(true);
        }
        this.fullHTMLEditing = fullHTMLEditing;
    }

    public JPopupMenu getPopupMenu() {
        if (this.menuContext == null) {
            this.menuContext = new MenuContext();
        }
        return this.menuContext.popup;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public SmartTextComponentSupport(JTextComponent comp) {
        this.comp = comp;
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1500);
        comp.getDocument().addUndoableEditListener(this);
        comp.addMouseListener(this);
        try {
            int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            comp.getInputMap().put(KeyStroke.getKeyStroke(90, shortcutMask), "undo");
            comp.getActionMap().put("undo", this.undoAction);
            comp.getInputMap().put(KeyStroke.getKeyStroke(89, shortcutMask), "redo");
            comp.getActionMap().put("redo", this.redoAction);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        this.cutAction.setAction(comp.getActionMap().get("cut-to-clipboard"));
        this.copyAction.setAction(comp.getActionMap().get("copy-to-clipboard"));
        comp.getActionMap().put("cut-to-clipboard", this.cutAction);
        comp.getActionMap().put("copy-to-clipboard", this.copyAction);
        comp.getActionMap().put("paste-from-clipboard", this.pasteAction);
        comp.addPropertyChangeListener("spelling", pce -> {
            Config cfg = Config.getConfig();
            boolean checkSpellingPreference = cfg.isCheckSpelling();
            boolean doCheck = this.isSpelling();
            if (checkSpellingPreference) {
                this.menuContext = null;
            }
            if (doCheck) {
                cfg.addPropertyChangeListener("checkSpelling", this.spellingPreferenceListener);
            } else {
                cfg.removePropertyChangeListener("checkSpelling", this.spellingPreferenceListener);
            }
            if (doCheck && checkSpellingPreference) {
                SpellChecker.register((JTextComponent)comp, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
            } else {
                SpellChecker.unregister((JTextComponent)comp);
            }
        });
        comp.addPropertyChangeListener("allowHTMLEditing", pce -> this.setAllowHTMLEditing((Boolean)pce.getNewValue()));
        comp.addPropertyChangeListener("fullHTMLEditing", pce -> this.setFullHTMLEditing((Boolean)pce.getNewValue()));
    }

    public void doPopup(MouseEvent e) {
        boolean enabled = ((Component)e.getSource()).isEnabled();
        if (!enabled) {
            return;
        }
        MenuContext tmpContext = this.menuContext;
        if (this.menuContext == null) {
            tmpContext = new MenuContext();
        }
        tmpContext.preparePopup();
        tmpContext.popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private boolean isStringInClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(this.comp);
        return t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    private String cutSelection() {
        int start = this.comp.getSelectionStart();
        int end = this.comp.getSelectionEnd();
        String selection = this.comp.getSelectedText();
        StringBuilder buf = new StringBuilder(this.comp.getText());
        buf.delete(start, end);
        this.comp.setText(buf.toString());
        this.comp.setCaretPosition(start);
        return selection;
    }

    private int getSelectionStatus() {
        int start = this.comp.getSelectionStart();
        int end = this.comp.getSelectionEnd();
        int length = this.comp.getText().length();
        if (end - start == 0) {
            return 0;
        }
        if (end - start == length) {
            return 2;
        }
        if (end > start) {
            return 1;
        }
        return 0;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
    }

    public boolean isSpelling() {
        return Boolean.TRUE.equals(this.comp.getClientProperty("spelling"));
    }

    void setSpelling(boolean doCheck) {
        this.comp.putClientProperty("spelling", doCheck);
    }

    public void installHoverButton(Action action) {
        if (this.buttonBox == null) {
            this.buttonBox = Box.createHorizontalBox();
            this.buttonBox.setVisible(false);
            this.comp.setLayout(new BorderLayout());
            this.buttonBox.add(Box.createGlue());
            this.comp.add((Component)this.buttonBox, "North");
            this.comp.addMouseListener(this);
        }
        JPlainButton button = new JPlainButton(action, false);
        button.setCursor(Cursor.getDefaultCursor());
        button.setOpaque(true);
        this.buttonBox.add(button);
        this.comp.validate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.buttonBox != null && this.comp.isEnabled()) {
            this.buttonBox.setVisible(true);
        }
        if (currentButtonBox != this.buttonBox && currentButtonBox != null) {
            currentButtonBox.setVisible(false);
        }
        currentButtonBox = this.buttonBox;
        currentComponent = this.comp;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!SwingUtilities.getLocalBounds(this.comp).contains(e.getPoint())) {
            if (this.buttonBox != null) {
                this.buttonBox.setVisible(false);
            }
            currentComponent = null;
            currentButtonBox = null;
        }
    }

    private class MenuContext {
        private JPopupMenu popup = new JPopupMenu();
        Action cutAction = new AbstractAction(Msg.get("edit.cut"), cutIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = SmartTextComponentSupport.this.cutSelection();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(selection), null);
            }
        };
        Action copyAction = new AbstractAction(Msg.get("edit.copy"), copyIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(SmartTextComponentSupport.this.comp.getSelectedText()), null);
            }
        };
        Action deleteAction = new AbstractAction(Msg.get("edit.delete"), removeSelectionIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartTextComponentSupport.this.cutSelection();
            }
        };
        Action selectAllAction = new AbstractAction(Msg.get("edit.selectAll"), selectAllIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartTextComponentSupport.this.comp.requestFocusInWindow();
                SmartTextComponentSupport.this.comp.selectAll();
            }
        };

        public MenuContext() {
            if (SmartTextComponentSupport.this.allowHTMLEditing) {
                this.popup.insert(SmartTextComponentSupport.this.openHtmlEditorAction, 0);
                this.popup.insert(new JSeparator(), 1);
            }
            boolean checkSpellingPreference = Config.getConfig().isCheckSpelling();
            if (SmartTextComponentSupport.this.isSpelling() && checkSpellingPreference && SpellChecker.getCurrentLocale() != null) {
                this.popup.add(SpellChecker.createCheckerMenu());
                this.popup.add(SpellChecker.createLanguagesMenu());
                this.popup.addSeparator();
            }
            this.popup.add(SmartTextComponentSupport.this.undoAction);
            this.popup.add(SmartTextComponentSupport.this.redoAction);
            this.popup.addSeparator();
            this.popup.add(this.cutAction);
            this.popup.add(this.copyAction);
            this.popup.add(SmartTextComponentSupport.this.pasteAction);
            this.popup.add(this.deleteAction);
            this.popup.addSeparator();
            this.popup.add(this.selectAllAction);
        }

        void preparePopup() {
            SmartTextComponentSupport.this.openHtmlEditorAction.putValue("Name", Msg.get("ui.openHTMLEditor"));
            SmartTextComponentSupport.this.undoAction.setEnabled(SmartTextComponentSupport.this.comp.isEditable() && SmartTextComponentSupport.this.undoManager.canUndo());
            SmartTextComponentSupport.this.redoAction.setEnabled(SmartTextComponentSupport.this.comp.isEditable() && SmartTextComponentSupport.this.undoManager.canRedo());
            int status = SmartTextComponentSupport.this.getSelectionStatus();
            this.cutAction.setEnabled(status != 0);
            this.copyAction.setEnabled(status != 0);
            SmartTextComponentSupport.this.pasteAction.setEnabled(SmartTextComponentSupport.this.isStringInClipboard());
            this.deleteAction.setEnabled(status != 0);
            this.selectAllAction.setEnabled(status != 2);
            if (!SmartTextComponentSupport.this.comp.isEditable()) {
                this.cutAction.setEnabled(false);
                SmartTextComponentSupport.this.pasteAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
            }
        }
    }
}

