/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public abstract class MenuBasedAutoCompleter<E> {
    protected JList<E> list = new JList();
    protected JPopupMenu popup = new JPopupMenu();
    protected JTextComponent textComp;
    private static final String AUTOCOMPLETER = "AUTOCOMPLETER";
    private ActionListener defaultEscapeAction;
    static Action showAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled()) {
                if (completer.popup.isVisible()) {
                    completer.selectNextPossibleValue();
                } else {
                    completer.showPopup();
                }
            }
        }
    };
    static Action upAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled() && completer.popup.isVisible()) {
                completer.selectPreviousPossibleValue();
            }
        }
    };
    Action hidePopupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
            if (tf.isEnabled()) {
                if (completer.popup.isVisible()) {
                    completer.popup.setVisible(false);
                } else if (MenuBasedAutoCompleter.this.defaultEscapeAction != null) {
                    MenuBasedAutoCompleter.this.defaultEscapeAction.actionPerformed(e);
                }
            }
        }
    };

    public MenuBasedAutoCompleter(JTextComponent comp) {
        this.textComp = comp;
        this.textComp.putClientProperty(AUTOCOMPLETER, this);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setBorder(null);
        this.list.putClientProperty(AUTOCOMPLETER, this);
        this.list.setFocusable(false);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                MenuBasedAutoCompleter.this.list.setSelectedIndex(MenuBasedAutoCompleter.this.list.locationToIndex(p));
                JComponent tf = (JComponent)me.getSource();
                MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
                completer.acceptedListItem(me, completer.list.getSelectedValue());
                completer.popup.setVisible(false);
            }
        });
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(scroll);
        this.popup.setFocusable(false);
        if (this.textComp instanceof JTextField) {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
        } else {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(32, 128), 0);
        }
        this.textComp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e == null) {
                    return;
                }
                Component cmp = e.getOppositeComponent();
                if (cmp == null) {
                    return;
                }
                if (!"javax.swing.JRootPane".equals(cmp.getClass().getName())) {
                    JComponent tf = (JComponent)e.getSource();
                    MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
                    SwingUtilities.invokeLater(() -> {
                        completer.popup.setVisible(false);
                        cmp.requestFocus();
                    });
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e == null) {
                    return;
                }
                JComponent tf = (JComponent)e.getSource();
                MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
                completer.showPopup();
            }
        });
        this.textComp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e == null) {
                    return;
                }
                JComponent tf = (JComponent)e.getSource();
                MenuBasedAutoCompleter completer = (MenuBasedAutoCompleter)tf.getClientProperty(MenuBasedAutoCompleter.AUTOCOMPLETER);
                int keyCode = e.getKeyCode();
                if (keyCode != 27 && keyCode != 9 && keyCode != 38 && keyCode != 40 && keyCode != 36 && keyCode != 35 && keyCode != 34 && keyCode != 33 && keyCode != 10) {
                    completer.showPopup();
                } else if (keyCode == 10) {
                    if (completer.list.getModel().getSize() == 1) {
                        completer.list.setSelectedIndex(0);
                    }
                    if (completer.list.getSelectedValue() != null) {
                        completer.acceptedListItem(e, completer.list.getSelectedValue());
                        completer.list.setListData(new String[0]);
                        completer.popup.setVisible(false);
                    }
                } else {
                    int lastIndex = completer.list.getModel().getSize() - 1;
                    int pageSize = completer.list.getVisibleRowCount();
                    int pageStartIndex = -1;
                    if (keyCode == 34) {
                        pageStartIndex = completer.list.getLastVisibleIndex() + pageSize;
                        if (pageStartIndex > lastIndex) {
                            pageStartIndex = lastIndex;
                        }
                    } else if (keyCode == 33) {
                        pageStartIndex = completer.list.getFirstVisibleIndex() - pageSize;
                        if (pageStartIndex < 0) {
                            pageStartIndex = 0;
                        }
                    } else if (keyCode == 36) {
                        pageStartIndex = 0;
                    } else if (keyCode == 35) {
                        pageStartIndex = lastIndex;
                    }
                    if (pageStartIndex != -1) {
                        completer.list.ensureIndexIsVisible(pageStartIndex);
                    }
                }
            }
        });
        this.textComp.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.defaultEscapeAction = this.textComp.getActionForKeyStroke(KeyStroke.getKeyStroke(27, 0));
        this.textComp.registerKeyboardAction(this.hidePopupAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MenuBasedAutoCompleter.this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.list.setRequestFocusEnabled(false);
    }

    protected void showPopup() {
        if (this.textComp.isEnabled() && this.updateListData() && this.list.getModel().getSize() != 0) {
            this.popup.setVisible(false);
            int size = this.list.getModel().getSize();
            Rectangle bounds = this.textComp.getGraphicsConfiguration().getBounds();
            int y = this.textComp.getLocationOnScreen().y + this.textComp.getHeight();
            int maxHeight = bounds.height - y;
            int maxRows = maxHeight / this.list.getCellBounds((int)0, (int)0).height;
            this.list.setVisibleRowCount(Math.min(size, maxRows - 1));
            int x = 0;
            try {
                int pos = Math.min(this.textComp.getCaret().getDot(), this.textComp.getCaret().getMark());
                x = (int)this.textComp.getUI().modelToView2D(this.textComp, pos, Position.Bias.Forward).getX();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.popup.pack();
            this.popup.show(this.textComp, 0, this.textComp.getHeight());
        } else {
            this.popup.setVisible(false);
        }
        this.textComp.requestFocus();
    }

    protected void selectNextPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(si + 1);
            this.list.ensureIndexIsVisible(si + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si > 0) {
            this.list.setSelectedIndex(si - 1);
            this.list.ensureIndexIsVisible(si - 1);
        }
    }

    protected abstract boolean updateListData();

    protected abstract void acceptedListItem(InputEvent var1, E var2);
}

