/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import se.datadosen.component.JWorkFlow;
import se.datadosen.util.LaF;

public class JWorkFlowStep
extends JComponent {
    private int step;
    private JComponent relativeComp;
    private float alpha = 1.0f;
    private Rectangle2D stringBounds;

    public JWorkFlowStep(int step, Object start, String path) {
        this(step, JWorkFlowStep.walkPath(start, path));
    }

    public JWorkFlowStep(int step, JComponent relativeComp) {
        this.step = step;
        this.relativeComp = relativeComp;
        this.setFont(new Font("Lucida Grande", 1, 36));
        this.setForeground(LaF.isDark() ? new Color(230, 230, 0) : new Color(0, 200, 0));
        this.setDoubleBuffered(false);
    }

    private static JComponent walkPath(Object start, String path) {
        Object current = start;
        for (String fieldName : path.split("\\.")) {
            try {
                Class<?> clazz = current.getClass();
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                current = field.get(current);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("No such field: " + fieldName + " in " + path);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (JComponent)current;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (this.getGraphics() != null) {
            this.repaint(this.getRealBounds());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() && visible) {
            return;
        }
        if (visible) {
            this.alpha = 0.0f;
        }
        super.setVisible(visible);
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
        this.stringBounds = null;
        this.repaint();
    }

    Rectangle getRealBounds() {
        if (this.stringBounds == null) {
            Graphics g = this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            this.stringBounds = metrics.getStringBounds("" + this.step, g);
        }
        double w = Math.max(this.stringBounds.getWidth(), this.stringBounds.getHeight());
        int side = (int)(w * 1.2);
        Point compLoc = this.getLocationRelativeLayeredPane(this.relativeComp);
        Dimension compSize = this.relativeComp.getSize();
        return new Rectangle(compLoc.x + (compSize.width - side) / 2, compLoc.y + (compSize.height - side) / 2, side, side);
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (!this.relativeComp.isShowing()) {
            return;
        }
        Rectangle bounds = this.getRealBounds();
        Rectangle2D sb = this.stringBounds;
        int side = bounds.width;
        g.translate(bounds.x, bounds.y);
        AlphaComposite composite = AlphaComposite.getInstance(3, this.alpha);
        g.setComposite(composite);
        if (this.step > 0) {
            g.drawString("" + this.step, (float)(((double)side - sb.getWidth()) / 2.0 - sb.getX()), (float)(((double)side - sb.getHeight()) / 2.0 - sb.getY()));
        }
        g.setStroke(new BasicStroke(this.getFont().getSize2D() / 8.0f));
        g.drawOval(0, 0, side, side);
        g.dispose();
    }

    Point getLocationRelativeLayeredPane(JComponent comp) {
        JLayeredPane layeredPane = JWorkFlow.getLayeredPane(SwingUtilities.getWindowAncestor(comp));
        return SwingUtilities.convertPoint(comp.getParent(), comp.getLocation(), layeredPane);
    }
}

