/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import net.jalbum.util.Animator;
import se.datadosen.component.JWorkFlowStep;

public class JWorkFlow
extends JComponent {
    JComponent refComp;
    private Animator.Control animControl;
    private boolean animate = false;
    private int currentIndex = 0;
    private boolean repeat = true;

    public JWorkFlow(JComponent refComp) {
        this.refComp = refComp;
        this.setLayout(new OverlayLayout(this));
        refComp.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L) {
                this.currentIndex = 0;
                this.setVisible(refComp.isShowing());
            }
        });
    }

    private JWorkFlowStep getCurrentStep() {
        return (JWorkFlowStep)this.getComponent(this.currentIndex);
    }

    public Stream<JWorkFlowStep> steps() {
        return Stream.of(this.getComponents()).map(e -> (JWorkFlowStep)e);
    }

    public void addStep(JWorkFlowStep step) {
        this.add(step);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
        this.repaint();
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    private void animate() {
        if (this.animControl != null) {
            this.animControl.abort();
        }
        this.steps().forEach(step -> step.setAlpha(0.0f));
        this.steps().forEach(step -> step.setVisible(false));
        if (this.isShowing() && this.refComp.isShowing()) {
            this.animControl = Animator.getInstance().playFor(1000, ctrl -> {
                if (!this.isVisible() || !this.refComp.isShowing()) {
                    ctrl.abort();
                    return;
                }
                JWorkFlowStep step = this.getCurrentStep();
                if (!step.isVisible()) {
                    step.setVisible(true);
                }
                step.setAlpha(1.0f - (1.0f - ctrl.getCurrentTimeNormalized()) * (1.0f - ctrl.getCurrentTimeNormalized()));
                Rectangle bounds = step.getRealBounds();
                bounds.grow(3, 3);
                step.repaint(bounds);
            }).setCycleCount(1).setAutoReverse(true);
            this.animControl.onDone(() -> {
                this.getCurrentStep().setVisible(false);
                int n = this.currentIndex = this.currentIndex < this.getComponentCount() - 1 ? this.currentIndex + 1 : 0;
                if (this.repeat) {
                    this.animate();
                } else {
                    this.uninstall();
                    this.refComp.repaint();
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        if (this.animate && (this.animControl == null || this.animControl.isAborted())) {
            this.animate();
        }
    }

    public void install(final Window window) {
        this.setBounds(SwingUtilities.getLocalBounds(window));
        window.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ JWorkFlow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.this$0.setBounds(SwingUtilities.getLocalBounds(window));
            }
        });
        JWorkFlow.getLayeredPane(window).add((Component)this, JLayeredPane.DRAG_LAYER);
        JWorkFlow.getLayeredPane(window).validate();
    }

    public void uninstall() {
        Window window = SwingUtilities.getWindowAncestor(this.refComp);
        JWorkFlow.getLayeredPane(window).remove(this);
        JWorkFlow.getLayeredPane(window).validate();
    }

    static JLayeredPane getLayeredPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getLayeredPane();
        }
        throw new IllegalArgumentException("window not of Swing type");
    }
}

