/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import se.datadosen.util.LaF;

public class JToolBarButton
extends JButton {
    private boolean showLabel = true;
    private boolean hoverStyle = false;
    private MouseListener myMouseListener;

    public JToolBarButton() {
        this.setRolloverIcon(null);
        this.init();
    }

    public JToolBarButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JToolBarButton(String text) {
        super(text);
        this.init();
    }

    public JToolBarButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JToolBarButton(Action action) {
        super(action);
        this.init();
    }

    public JToolBarButton(Action action, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(action);
        this.init();
    }

    public boolean isHoverStyle() {
        return this.hoverStyle;
    }

    public void setHoverStyle(boolean hoverStyle) {
        this.hoverStyle = hoverStyle;
        this.setBorderPainted(!hoverStyle);
        this.setContentAreaFilled(!hoverStyle);
        if (hoverStyle) {
            this.addMouseListener(this.myMouseListener);
        } else {
            this.removeMouseListener(this.myMouseListener);
        }
    }

    protected boolean isOnToolbar() {
        JToolBarButton b = this;
        for (Container parent = b.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.setFocusable(false);
        if (LaF.isAnyOf("Aqua")) {
            this.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.putClientProperty("JButton.segmentPosition", "only");
            Font font = (Font)UIManager.getDefaults().get("Button.font");
            this.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        } else if (LaF.isAnyOf("Windows", "FlatLaf")) {
            this.setMargin(new Insets(4, 6, 3, 6));
        } else {
            this.setMargin(new Insets(1, 2, 1, 3));
        }
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JToolBarButton.this.setBorderPainted(true);
                JToolBarButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JToolBarButton.this.setBorderPainted(false);
                JToolBarButton.this.setContentAreaFilled(false);
            }
        };
        this.setHoverStyle(this.hoverStyle);
    }

    @Override
    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        if (!this.isEnabled()) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        super.paintComponent(g2d);
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        this.setPropertiesFromAction(a);
        a.addPropertyChangeListener(evt -> this.setPropertiesFromAction(a));
    }

    protected void setPropertiesFromAction(Action action) {
        Icon rolloverIcon;
        if (action != null && (rolloverIcon = (Icon)action.getValue("rolloverIcon")) != null) {
            this.setRolloverIcon(rolloverIcon);
        }
    }
}

