/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class JSmartToggleButton
extends JToggleButton {
    private boolean showLabel = true;
    private Action action;
    private String selectedText;
    private String ordinaryText;
    private final ItemListener itemListener = e -> {
        if (e.getStateChange() == 1) {
            this.ordinaryText = this.getText();
            this.setText(this.selectedText);
        } else {
            this.setText(this.ordinaryText);
        }
    };

    public JSmartToggleButton() {
        this.init();
    }

    public JSmartToggleButton(Action action) {
        super(action);
        this.action = action;
        this.init();
    }

    public JSmartToggleButton(Action action, boolean showLabel) {
        super(action);
        this.action = action;
        this.showLabel = showLabel;
        this.init();
    }

    private void init() {
        if (this.action != null) {
            this.setText((String)this.action.getValue("Name"));
            this.setIcon((Icon)this.action.getValue("SmallIcon"));
        }
    }

    @Override
    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }

    public void setSelectedText(String selectedText) {
        this.addItemListener(this.itemListener);
        this.removeItemListener(this.itemListener);
        this.selectedText = selectedText;
        if (selectedText != null) {
            this.addItemListener(this.itemListener);
        }
    }
}

