/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.jalbum.Icons;

public class JRatingSlider
extends JPanel {
    private Icon emptyStarIcon = Icons.small("star-empty");
    private Icon starIcon = Icons.small("star");
    private int maxValue = 5;
    private int value;
    private int lastValue = this.value = 0;
    private JLabel[] labels;
    private static final int MARGIN = 5;
    private volatile ArrayList<ChangeListener> changeListeners;
    private final int SCALE = 2;
    private BufferedImage backBuffer;

    public JRatingSlider() {
        this.init();
    }

    public JRatingSlider(int maxValue) {
        this.maxValue = maxValue;
        this.init();
    }

    public JRatingSlider(int maxValue, Icon grey, Icon yellow) {
        this.maxValue = maxValue;
        this.emptyStarIcon = grey;
        this.starIcon = yellow;
        this.init();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        if (value < 0) {
            value = 0;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        for (int i = 0; i < this.maxValue; ++i) {
            this.labels[i].setIcon(i < value ? this.starIcon : this.emptyStarIcon);
        }
    }

    public void changeValue(int value) {
        if (this.value != value) {
            this.setValue(value);
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(cl);
    }

    public void removeChangeListner(ChangeListener cl) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(cl);
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.changeListeners) {
            cl.stateChanged(ce);
        }
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.setLayout(new FlowLayout(3, 0, 0));
        this.labels = new JLabel[this.maxValue];
        for (int i = 0; i < this.maxValue; ++i) {
            this.labels[i] = new JLabel(this.emptyStarIcon);
            this.add(this.labels[i]);
        }
        this.setValue(this.value);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JRatingSlider.this.lastValue = JRatingSlider.this.value;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JRatingSlider.this.mouseAt(e.getPoint());
                if (JRatingSlider.this.value != JRatingSlider.this.lastValue) {
                    JRatingSlider.this.fireStateChanged();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JRatingSlider.this.mouseAt(e.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void mouseAt(Point p) {
        if (p.x < 5) {
            this.setValue(0);
        } else {
            for (int i = this.maxValue; i > 0; --i) {
                if (p.x - 5 < this.labels[i - 1].getLocation().x) continue;
                this.setValue(i);
                break;
            }
        }
    }

    @Override
    protected void paintChildren(Graphics g2d) {
        Graphics2D bufferG;
        Graphics2D g = (Graphics2D)g2d;
        if (this.backBuffer == null || this.backBuffer.getWidth() != this.getWidth() * 2 || this.backBuffer.getHeight() != this.getHeight() * 2) {
            this.backBuffer = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth() * 2, this.getHeight() * 2, 3);
        } else {
            bufferG = this.backBuffer.createGraphics();
            bufferG.setComposite(AlphaComposite.Clear);
            bufferG.fillRect(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight());
            bufferG.dispose();
        }
        bufferG = this.backBuffer.createGraphics();
        bufferG.scale(2.0, 2.0);
        super.paintChildren(bufferG);
        bufferG.dispose();
        g.drawImage(this.backBuffer, 0, 0, this.getWidth(), this.getHeight(), null);
    }
}

