/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class JPlainButton
extends JButton {
    protected boolean showLabel = true;
    private int margin = 3;
    private ButtonUI ui = new BasicButtonUI();

    public JPlainButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JPlainButton(Action a) {
        super(a);
        this.init();
    }

    public JPlainButton(Action a, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.init();
    }

    public JPlainButton(Action a, boolean showLabel, int margin) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.margin = margin;
        this.init();
    }

    public JPlainButton(String text) {
        super(text);
        this.init();
    }

    public JPlainButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JPlainButton(Icon icon, int margin) {
        super(icon);
        this.margin = margin;
        this.init();
    }

    public JPlainButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.init();
        this.setRolloverEnabled(true);
        this.setRolloverIcon(rolloverIcon);
    }

    public JPlainButton() {
        this.init();
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    @Override
    public void updateUI() {
        this.setUI(this.ui);
        this.setFont((Font)UIManager.get("Button.font"));
    }

    @Override
    public void setBorder(Border border) {
    }

    public void setRealBorder(Border border) {
        super.setBorder(border);
    }

    private void init() {
        this.updateUI();
        super.setBorder(BorderFactory.createEmptyBorder(this.margin, this.margin, this.margin, this.margin));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (defaultIcon != null) {
            this.setRolloverEnabled(true);
            if (defaultIcon instanceof ImageIcon) {
                Icon rolloverIcon;
                Action action = this.getAction();
                if (action != null && (rolloverIcon = (Icon)action.getValue("rolloverIcon")) != null) {
                    this.setRolloverIcon(rolloverIcon);
                    return;
                }
                this.setRolloverIcon(JPlainButton.brighten((ImageIcon)defaultIcon, 1.2f));
            }
        } else {
            this.setRolloverEnabled(false);
        }
    }

    @Override
    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }

    private static Icon brighten(ImageIcon icon, float value) {
        return new BrightnessIcon(icon, value);
    }

    public static class BrightnessIcon
    implements Icon {
        private final Icon delegate;
        private final float brightnessFactor;

        public BrightnessIcon(Icon delegate, float brightnessFactor) {
            this.delegate = delegate;
            this.brightnessFactor = brightnessFactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.delegate == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                double scaleX = 1.0;
                double scaleY = 1.0;
                GraphicsConfiguration gc = c.getGraphicsConfiguration();
                if (gc != null) {
                    AffineTransform tx = g2.getTransform();
                    scaleX = tx.getScaleX();
                    scaleY = tx.getScaleY();
                }
                int w = (int)Math.ceil((double)this.delegate.getIconWidth() * scaleX);
                int h = (int)Math.ceil((double)this.delegate.getIconHeight() * scaleY);
                BufferedImage temp = c.getGraphicsConfiguration().createCompatibleImage(w, h, 3);
                Graphics2D tg = temp.createGraphics();
                try {
                    tg.scale(scaleX, scaleY);
                    this.delegate.paintIcon(c, tg, 0, 0);
                }
                finally {
                    tg.dispose();
                }
                RescaleOp rescale = new RescaleOp(this.brightnessFactor, 0.0f, null);
                temp = rescale.filter(temp, null);
                g2.drawImage(temp, x, y, this.delegate.getIconWidth(), this.delegate.getIconHeight(), null);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return this.delegate.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.delegate.getIconHeight();
        }
    }
}

