/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.jalbum.util.Parameters;
import se.datadosen.component.MapClip;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;

public class JParametersTable
extends JTable
implements ClipboardOwner {
    static Icon cutIcon = Icons.small("cut");
    static Icon copyIcon = Icons.small("copy");
    static Icon pasteIcon = Icons.small("paste");
    static Icon removeSelectionIcon = Icons.small("close");
    static Icon insertRowIcon = Icons.small("insert-row");
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private boolean editable = true;
    private ArrayList<Map.Entry<String, String>> items = new ArrayList();
    private MapModel theModel = new MapModel();
    private Color oddColor;
    Action cutAction = new AbstractAction(Msg.get("edit.cut"), cutIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JParametersTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry> clip = JParametersTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                JParametersTable.this.clipboard.setContents(new MapClip(clip), JParametersTable.this);
                JParametersTable.this.handlePasteEnabling();
            }
        }
    };
    Action copyAction = new AbstractAction(Msg.get("edit.copy"), copyIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JParametersTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry> clip = JParametersTable.this.theModel.getRows(rows[0], rows[rows.length - 1]);
                JParametersTable.this.clipboard.setContents(new MapClip(clip), JParametersTable.this);
                JParametersTable.this.handlePasteEnabling();
            }
        }
    };
    Action pasteAction = new AbstractAction(Msg.get("edit.paste"), pasteIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            Transferable t = JParametersTable.this.clipboard.getContents(JParametersTable.this);
            try {
                int lastRow;
                ArrayList content = t.isDataFlavorSupported(MapClip.mapFlavor) ? (ArrayList)t.getTransferData(MapClip.mapFlavor) : this.parseStringFromClipboard(t);
                int[] rows = JParametersTable.this.getSelectedRows();
                int firstRow = rows.length > 0 ? rows[0] : 0;
                int n = lastRow = rows.length > 0 ? rows[rows.length - 1] : 0;
                if (lastRow > firstRow) {
                    JParametersTable.this.theModel.deleteRows(firstRow, lastRow);
                }
                JParametersTable.this.theModel.insertRows(firstRow, content);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }

        private ArrayList<Map.Entry<String, String>> parseStringFromClipboard(Transferable t) throws UnsupportedFlavorException, IOException {
            String line;
            ArrayList<Map.Entry<String, String>> rows = new ArrayList<Map.Entry<String, String>>();
            String content = (String)t.getTransferData(DataFlavor.stringFlavor);
            BufferedReader reader = new BufferedReader(new StringReader(content));
            char[] delims = new char[]{'=', '\t', ',', ';', ':'};
            while ((line = reader.readLine()) != null) {
                String key = line;
                String value = "";
                int indexOfEquals = JParametersTable.this.indexOf(line, delims);
                if (indexOfEquals >= 0) {
                    key = line.substring(0, indexOfEquals);
                    value = line.substring(indexOfEquals + 1);
                }
                key = key.trim();
                value = value.trim();
                rows.add(new Entry(key, value));
            }
            return rows;
        }
    };
    Action insertAction = new AbstractAction(Msg.get("edit.insertRow"), insertRowIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JParametersTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry<String, String>> newRows = new ArrayList<Map.Entry<String, String>>();
                newRows.add(new Entry("", ""));
                JParametersTable.this.theModel.insertRows(rows[0], newRows);
                JParametersTable.this.selectionModel.setSelectionInterval(rows[0], rows[0]);
            }
        }
    };
    Action deleteAction = new AbstractAction(Msg.get("edit.delete"), removeSelectionIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JParametersTable.this.getSelectedRows();
            if (rows.length > 0) {
                JParametersTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
            }
        }
    };

    public JParametersTable() {
        Color c = JAlbumColor.textHighlight;
        this.oddColor = new Color(0, 0, 64, 8);
        super.setModel(new DefaultTableModel());
        super.setRowSelectionAllowed(false);
        this.setSelectionMode(1);
        this.setRowSelectionAllowed(true);
        JPopupMenu popup = new JPopupMenu();
        this.handlePasteEnabling();
        popup.add(this.cutAction);
        popup.add(this.copyAction);
        popup.add(this.pasteAction);
        popup.add(this.insertAction);
        popup.add(this.deleteAction);
        this.setComponentPopupMenu(popup);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int[] rows;
                if (e.getKeyCode() == 127 && (rows = JParametersTable.this.getSelectedRows()).length > 0) {
                    JParametersTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private int indexOf(String s, char[] delims) {
        int i = -1;
        for (char delim : delims) {
            i = s.indexOf(delim);
            if (i < 0) continue;
            return i;
        }
        return i;
    }

    private void handlePasteEnabling() {
        boolean supported;
        block3: {
            supported = false;
            try {
                DataFlavor[] flavors;
                for (DataFlavor flavor : flavors = this.clipboard.getAvailableDataFlavors()) {
                    if (!flavor.equals(MapClip.mapFlavor) && !flavor.equals(DataFlavor.stringFlavor)) continue;
                    supported = true;
                }
            }
            catch (IllegalArgumentException ex) {
                if (!JAlbum.logger.isLoggable(Level.FINE)) break block3;
                ex.printStackTrace(System.err);
            }
        }
        this.pasteAction.setEnabled(supported && this.isEnabled());
        this.insertAction.setEnabled(this.isEnabled());
    }

    public JParametersTable(String nameLabel, String valueLabel) {
        this();
        this.setHeaderNames(nameLabel, valueLabel);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
        if (this.isCellSelected(rowIndex, colIndex)) {
            c.setBackground(JAlbumColor.textHighlight);
            c.setForeground(JAlbumColor.textHighlightText);
        } else {
            c.setForeground(JAlbumColor.textText);
            if (rowIndex % 2 == 1) {
                c.setBackground(this.oddColor);
            } else {
                c.setBackground(this.getBackground());
            }
        }
        return c;
    }

    public void setCellEditable(boolean editable) {
        this.editable = editable;
    }

    public void setHeaderNames(String nameLabel, String valueLabel) {
        this.theModel = new MapModel();
        this.theModel.colNames[0] = nameLabel;
        this.theModel.colNames[1] = valueLabel;
        super.setModel(this.theModel);
    }

    public void clear() {
        int size = this.items.size();
        this.items.clear();
        this.theModel.fireTableRowsDeleted(1, size);
    }

    public Parameters getData() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        Parameters data = new Parameters();
        for (Map.Entry<String, String> item : this.items) {
            if (item.getKey().isEmpty()) continue;
            data.add(item.getKey(), item.getValue());
        }
        return data;
    }

    public void setData(Parameters data) {
        this.items.clear();
        this.theModel.fireTableRowsDeleted(1, this.items.size());
        for (Map.Entry<String, String> e : data) {
            this.items.add(new Entry(e.getKey(), e.getValue()));
        }
        this.theModel.fireTableRowsInserted(1, this.items.size());
        this.theModel.fireTableDataChanged();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.handlePasteEnabling();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isEnabled()) {
            Color inactive = JAlbumColor.control;
            Color dim = new Color(inactive.getRed(), inactive.getGreen(), inactive.getBlue(), 128);
            g.setColor(dim);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class MapModel
    extends AbstractTableModel {
        public String[] colNames = new String[]{"Name", "Value"};

        MapModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JParametersTable.this.editable;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return JParametersTable.this.items.size() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= JParametersTable.this.items.size()) {
                return "";
            }
            Map.Entry<String, String> item = JParametersTable.this.items.get(row);
            return col == 0 ? item.getKey() : item.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (row >= JParametersTable.this.items.size()) {
                Entry item = col == 0 ? new Entry(aValue, "") : new Entry("", aValue);
                JParametersTable.this.items.add(item);
            } else {
                Map.Entry<String, String> oldItem = JParametersTable.this.items.get(row);
                Entry item = col == 0 ? new Entry(aValue, oldItem.getValue()) : new Entry(oldItem.getKey(), aValue);
                JParametersTable.this.items.set(row, item);
            }
        }

        public void insertRows(int index, Collection<Map.Entry<String, String>> rows) {
            JParametersTable.this.items.addAll(index, rows);
            this.fireTableRowsInserted(index, index + rows.size());
        }

        public ArrayList<Map.Entry> deleteRows(int firstRow, int lastRow) {
            ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
            if (lastRow >= JParametersTable.this.items.size()) {
                lastRow = JParametersTable.this.items.size() - 1;
            }
            for (int i = lastRow; i >= firstRow; --i) {
                rows.add(JParametersTable.this.items.remove(i));
            }
            this.fireTableRowsDeleted(firstRow, lastRow);
            return rows;
        }

        public ArrayList<Map.Entry> getRows(int firstRow, int lastRow) {
            ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
            if (lastRow >= JParametersTable.this.items.size()) {
                lastRow = JParametersTable.this.items.size() - 1;
            }
            for (int i = firstRow; i <= lastRow; ++i) {
                rows.add(JParametersTable.this.items.get(i));
            }
            return rows;
        }
    }

    class Entry
    implements Map.Entry {
        Object key;
        Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object other) {
            return this.key.equals(((Entry)other).key);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object parm1) {
            this.value = parm1;
            return this;
        }
    }
}

