/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Action;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.MarginIcon;
import se.datadosen.jalbum.Icons;
import se.datadosen.util.Platform;

public class JNotificationsButton
extends JToolBarButton {
    static int notifications = 0;

    public JNotificationsButton(Action action) {
        super(action, false);
        this.setIcon();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setIcon();
    }

    public void setNotifications(int numberOfNotifications) {
        notifications = numberOfNotifications;
        this.repaint();
    }

    private void setIcon() {
        this.setIcon("com.apple.laf.AquaButtonUI".equals(this.getUI().getClass().getName()) ? Icons.small("megaphone") : new MarginIcon(new Insets(0, 0, 0, 8), Icons.small("megaphone")));
    }

    public int getNotifications() {
        return notifications;
    }

    @Override
    public void paintBorder(Graphics g2d) {
        super.paintBorder(g2d);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (!Platform.isMac()) {
            g.setFont(new Font("SansSerif", 1, 11));
        } else {
            g.setFont(new Font("Helvetica", 1, 12));
        }
        FontMetrics metrics = g.getFontMetrics();
        int fh = metrics.getHeight();
        int fw = metrics.stringWidth("" + notifications);
        int h = fh;
        int w = Math.max(fh, fw);
        if (notifications > 9) {
            w += 6;
        }
        if (Platform.isMac()) {
            ++w;
            ++h;
        } else {
            --w;
            --h;
        }
        if (notifications > 0) {
            g.setColor(new Color(0, 0, 0, 100));
            this.fillSemi(g, this.getWidth() - w - 1, 2, w + 1, h + 1);
            g.setColor(Color.white);
            this.fillSemi(g, this.getWidth() - w - 3, 0, w + 1, h + 1);
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0xFF8888), 0.0f, 10.0f, Color.RED, false);
            g.setPaint(gradient);
            this.fillSemi(g, this.getWidth() - w - 2, 1, w - 1, h - 1);
            g.setColor(Color.white);
            if (Platform.isMac()) {
                g.translate(-1.0, -0.5);
            } else {
                g.translate(-1, -1);
            }
            g.drawString("" + notifications, this.getWidth() - 2 - (w + fw) / 2, h - 2);
            g.dispose();
        }
    }

    private void fillSemi(Graphics2D g, int x, int y, int width, int height) {
        g.fillRoundRect(x, y, width, height, height, height);
    }
}

