/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JNarrowSlider
extends JSlider {
    public JNarrowSlider() {
        this.init();
    }

    public JNarrowSlider(int orientation) {
        super(orientation);
        this.init();
    }

    public JNarrowSlider(int min, int max) {
        super(min, max);
        this.init();
    }

    public JNarrowSlider(int min, int max, int value) {
        super(min, max, value);
        this.init();
    }

    public JNarrowSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.init();
    }

    public JNarrowSlider(BoundedRangeModel brm) {
        super(brm);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref.width /= 2;
        return pref;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return "" + this.getValue();
    }

    private void init() {
        SliderPopupListener listener = new SliderPopupListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    private class SliderPopupListener
    extends MouseAdapter {
        private final JWindow toolTip = new JWindow();
        private final JLabel label = new JLabel("", 0);
        private final Dimension size = new Dimension(30, 20);
        private int prevValue = -1;

        protected SliderPopupListener() {
            this.label.setOpaque(false);
            this.label.setBackground(UIManager.getColor("ToolTip.background"));
            this.label.setBorder(UIManager.getBorder("ToolTip.border"));
            this.toolTip.add(this.label);
            this.toolTip.setSize(this.size);
        }

        protected void updateToolTip(MouseEvent me) {
            JSlider slider = (JSlider)me.getComponent();
            int intValue = slider.getValue();
            if (this.prevValue != intValue) {
                this.label.setText("" + slider.getValue());
                Point pt = me.getPoint();
                pt.y = -this.size.height;
                SwingUtilities.convertPointToScreen(pt, me.getComponent());
                pt.translate(-this.size.width / 2, 0);
                this.toolTip.setLocation(pt);
            }
            this.prevValue = intValue;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.updateToolTip(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && SwingUtilities.isLeftMouseButton(me)) {
                this.toolTip.setVisible(true);
                this.updateToolTip(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.toolTip.setVisible(false);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JSlider s = (JSlider)e.getComponent();
            int i = s.getValue() - e.getWheelRotation();
            BoundedRangeModel m = s.getModel();
            s.setValue(Math.min(Math.max(i, m.getMinimum()), m.getMaximum()));
        }
    }
}

