/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.util.LambdaAction;

public class JModalPanel<T extends Window>
extends JPanel {
    protected T window;
    private Component lastFocusOwner;

    public JLayeredPane getLayeredPane() {
        if (this.window instanceof JDialog) {
            return ((JDialog)this.window).getLayeredPane();
        }
        if (this.window instanceof JFrame) {
            return ((JFrame)this.window).getLayeredPane();
        }
        throw new IllegalArgumentException("Window must be either JDialog or JFrame. Is " + String.valueOf(this.window));
    }

    public Container getContentPane() {
        if (this.window instanceof JDialog) {
            return ((JDialog)this.window).getContentPane();
        }
        if (this.window instanceof JFrame) {
            return ((JFrame)this.window).getContentPane();
        }
        throw new IllegalArgumentException("Window must be either JDialog or JFrame. Is " + String.valueOf(this.window));
    }

    private JLayeredPane layeredPane() {
        return this.getLayeredPane();
    }

    public JModalPanel(T window) {
        this.init(window);
    }

    public JModalPanel(JComponent panel) {
        panel.addHierarchyListener(he -> {
            if ((he.getChangeFlags() & 1L) != 0L && SwingUtilities.getWindowAncestor(panel) != null) {
                this.init(SwingUtilities.getWindowAncestor(panel));
            }
        });
    }

    private void init(T window) {
        this.window = window;
        this.setBounds(this.layeredPane().getBounds());
        this.getLayeredPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JModalPanel.this.setBounds(JModalPanel.this.layeredPane().getBounds());
            }
        });
        this.setBackground(new Color(0, 0, 0, 128));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(80, 0, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Component deepest = SwingUtilities.getDeepestComponentAt(JModalPanel.this, e.getX(), e.getY());
                if (deepest == JModalPanel.this) {
                    JModalPanel.this.close();
                }
            }
        });
        this.registerKeyboardAction(new LambdaAction(() -> this.close()), "close", KeyStroke.getKeyStroke(27, 0), 2);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        FocusManager mgr = FocusManager.getCurrentManager();
        if (visible) {
            this.lastFocusOwner = mgr.getFocusOwner();
        } else if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocusInWindow();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void activate() {
        this.layeredPane().remove(this);
        this.layeredPane().add((Component)this, JLayeredPane.POPUP_LAYER);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.layeredPane().remove(this);
    }
}

