/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.datadosen.component.JToolBarButton;
import se.datadosen.jalbum.ActionTracker;
import se.datadosen.jalbum.Icons;

public class JMenuButton
extends JToolBarButton {
    protected JPopupMenu menu = new JPopupMenu();
    protected Action defaultAction;
    protected Point plantPoint;
    private List<Action> actions = new ArrayList<Action>();
    private static final String PLACEHOLDER = "  ";
    private static final Icon rightIcon = Icons.get("triangle-down2");
    private PropertyChangeListener listener = pce -> {
        if ("enabled".equals(pce.getPropertyName()) && this.defaultAction == null) {
            this.setEnabled(this.actions.stream().anyMatch(a -> a.isEnabled()));
        }
    };

    public JMenuButton() {
        super("");
        this.setText("");
        this.init();
    }

    public JMenuButton(String text) {
        super(text);
        this.init();
    }

    public JMenuButton(Icon icon) {
        super(icon);
        this.setText("");
        this.init();
    }

    public JMenuButton(Action defaultAction) {
        this.defaultAction = defaultAction;
        this.configurePropertiesFromAction(defaultAction);
        this.setPropertiesFromAction(defaultAction);
        defaultAction.addPropertyChangeListener(evt -> {
            this.configurePropertiesFromAction(defaultAction);
            this.setPropertiesFromAction(defaultAction);
        });
        this.init();
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            if (((String)text).length() > 0) {
                text = (String)text + " ";
            }
            text = (String)text + PLACEHOLDER;
            super.setText((String)text);
            if (PLACEHOLDER.equals(this.getToolTipText())) {
                this.setToolTipText(null);
            }
        } else {
            super.setText((String)text);
        }
    }

    @Override
    public Component add(Component c) {
        return this.menu.add(c);
    }

    public JMenuItem add(Action a) {
        this.actions.add(a);
        a.addPropertyChangeListener(this.listener);
        return this.menu.add(new ActionTracker(a));
    }

    public void addActions(Action ... actions) {
        for (Action a : actions) {
            this.add(a);
        }
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public void setMenu(JPopupMenu menu) {
        this.menu = menu;
    }

    public void setMenuVisible(boolean visible) {
        if (this.menu.isShowing() && !visible) {
            this.menu.setVisible(false);
        } else if (!this.menu.isShowing() && visible) {
            this.onShowMenu();
            this.menu.show(this, 0, this.getHeight());
        }
    }

    private void init() {
        this.addActionListener(e -> {
            if (this.defaultAction != null && this.plantPoint.x < this.getWidth() / 2) {
                this.defaultAction.actionPerformed(e);
            } else {
                this.setMenuVisible(true);
            }
            this.plantPoint = null;
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JMenuButton.this.plantPoint = e.getPoint();
            }
        });
    }

    protected void onShowMenu() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (rightIcon != null) {
            Insets insets = this.getInsets();
            int x = this.getWidth() - insets.right - rightIcon.getIconWidth();
            int y = (this.getHeight() - rightIcon.getIconHeight()) / 2;
            ButtonModel model = this.getModel();
            Graphics2D g2 = (Graphics2D)g.create();
            if (!model.isEnabled() && rightIcon instanceof ImageIcon) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            rightIcon.paintIcon(this, g2, x, y);
            g2.dispose();
        }
    }
}

