/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import se.datadosen.component.search.UITarget;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.util.IO;

public class JLinkLabel
extends JLabel {
    private Color defaultColor = this.getForeground();
    private MouseListener mouseListener;
    private transient Vector actionListeners;
    private String url;
    private JComponent comp;
    private Exception exception;
    private Action action;

    public JLinkLabel() {
        this("");
    }

    public JLinkLabel(final JComponent comp, String text) {
        this(text);
        this.comp = comp;
        this.setForeground(JAlbumColor.linkText);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JLinkLabel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.this$0.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                UITarget target = new UITarget(comp);
                target.open(e);
            }
        });
    }

    public JLinkLabel(String text) {
        this.setText(text);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JLinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JLinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JLinkLabel.this.doClick();
            }
        };
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setForeground(this.url != null ? JAlbumColor.linkText : this.defaultColor);
            if (this.mouseListener != null) {
                this.removeMouseListener(this.mouseListener);
                this.addMouseListener(this.mouseListener);
            }
        } else {
            this.setForeground(JAlbumColor.textInactiveText);
            this.removeMouseListener(this.mouseListener);
        }
    }

    public void doClick() {
        if (this.actionListeners != null) {
            this.fireActionPerformed(new ActionEvent(this, 0, null));
            return;
        }
        if (this.action != null) {
            this.action.actionPerformed(null);
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(this.url));
        }
        catch (URISyntaxException ex) {
            try {
                Desktop.getDesktop().browse(this.getURI());
            }
            catch (IOException ex2) {
                System.err.println(ex2);
                this.exception = ex2;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
            this.exception = ex;
        }
    }

    public JLinkLabel(String url, String text) {
        this(text);
        this.setURL(url);
    }

    public JLinkLabel(String url, String text, String tooltip) {
        this(text);
        this.setURL(url);
        this.setToolTipText(tooltip);
    }

    public JLinkLabel(Action action) {
        this((String)action.getValue("Name"));
        this.action = action;
        this.setURL("localAction");
        this.setToolTipText((String)action.getValue("ShortDescription"));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.url == null && this.comp == null || this.getText() == null || this.getText().length() == 0) {
            return;
        }
        Insets in = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int x = in.left;
        int baseline = -1;
        try {
            baseline = this.getBaseline(this.getWidth(), this.getHeight());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (baseline == -1) {
            baseline = in.top + fm.getHeight() - fm.getDescent();
        }
        int y = baseline + 1;
        g.drawLine(x, y, x + fm.stringWidth(this.getText()), y);
    }

    public void setURL(String newURL) {
        this.url = newURL;
        if (this.url != null) {
            this.setForeground(JAlbumColor.linkText);
            this.removeMouseListener(this.mouseListener);
            this.addMouseListener(this.mouseListener);
        } else {
            this.setForeground(this.defaultColor);
            this.removeMouseListener(this.mouseListener);
        }
    }

    public String getURL() {
        return this.url;
    }

    public URI getURI() {
        try {
            return new URI(IO.urlEncode(this.url));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Exception getIOException() {
        return this.exception;
    }

    public void clearIOException() {
        this.exception = null;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }
}

