/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jalbum.browser.Browsers;
import net.jalbum.browser.WebBrowser;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.LaF;

public class JHtmlEditor {
    public static String showEditor(JComponent parent, String initialText) {
        return JHtmlEditor.showEditor(parent, initialText, false);
    }

    public static String showEditor(JComponent parent, String initialText, boolean full) {
        try {
            JEditorDialog dialog = new JEditorDialog(SwingUtilities.windowForComponent(parent), initialText, full);
            dialog.setVisible(true);
            return dialog.okHit ? dialog.getText() : null;
        }
        catch (IOException ex) {
            Debug.showErrorDialog(parent, ex);
            return initialText;
        }
        catch (InvocationTargetException ex) {
            Debug.showErrorDialog(parent, ex.getCause());
            return initialText;
        }
    }

    private static class JEditorDialog
    extends JSmartDialog {
        boolean okHit;
        WebBrowser browser = Browsers.create();
        Action okAction = new AbstractAction(Msg.get("ok")){

            @Override
            public void actionPerformed(ActionEvent e) {
                okHit = true;
                this.setVisible(false);
            }
        };
        Action cancelAction = new AbstractAction(Msg.get("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setVisible(false);
            }
        };
        private Object result;
        private Throwable throwable;

        private static String escapeString(String s) {
            s = s.replace("\\", "\\\\");
            s = s.replace("\"", "\\\"");
            s = s.replace("'", "\\'");
            s = s.replace("\n", "\\\n");
            return s;
        }

        public JEditorDialog(Window parent, String initialText) throws IOException, InvocationTargetException {
            this(parent, initialText, false);
        }

        public JEditorDialog(Window parent, String initialText, boolean full) throws IOException, InvocationTargetException {
            super(parent, Msg.get("ui.htmlEditorTitle"), Dialog.ModalityType.DOCUMENT_MODAL);
            this.registerActions(this.okAction, this.cancelAction);
            this.getRootPane().setDefaultButton(null);
            this.add(this.browser.getView());
            ContextHelp help = ContextHelp.getInstance();
            help.add(this.browser.getView(), "HTML_Editor");
            help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
            this.browser.load(new File(Config.getConfig().progDir, "system/editor.html").toURI().toURL().toString());
            try {
                this.browser.waitUntilLoaded();
                this.onFX(() -> {
                    if (!this.browser.elementIDExists("editor")) {
                        System.err.println("No editor id found in system/editor.html");
                        return null;
                    }
                    if (LaF.isDark()) {
                        this.browser.executeScript("makeDark()");
                    }
                    if (full) {
                        this.browser.executeScript("makeFull()");
                    }
                    String script = "replaceDOM(document.getElementById('editor').firstChild, '" + JEditorDialog.escapeString(initialText) + "')";
                    this.browser.executeScript(script);
                    return null;
                });
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JHtmlEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.pack();
        }

        private <T> T onFX(Supplier<T> sup) throws InterruptedException, InvocationTargetException {
            this.result = null;
            this.throwable = null;
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                try {
                    this.result = sup.get();
                }
                catch (Throwable t) {
                    this.throwable = t;
                }
                finally {
                    latch.countDown();
                }
            });
            latch.await();
            if (this.throwable != null) {
                throw new InvocationTargetException(this.throwable);
            }
            return (T)this.result;
        }

        private String getText() {
            try {
                return this.onFX(() -> (String)this.browser.executeScript("readDOM(document.getElementById('editor').firstChild)"));
            }
            catch (InterruptedException ex) {
                return "";
            }
            catch (InvocationTargetException ex) {
                return "";
            }
        }
    }
}

