/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class JFormattedComboBox<E>
extends JComboBox<E> {
    public static final Formatter PLAIN_FORMAT = data -> String.valueOf(data);
    public static final Formatter PERCENTAGE_FORMAT = data -> {
        int val = (int)(100.0 * Double.valueOf(data.toString()));
        return String.format("%d%%", val);
    };
    private Formatter formatter = PLAIN_FORMAT;

    public Formatter getFormat() {
        return this.formatter;
    }

    public JFormattedComboBox setFormat(Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public JFormattedComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
        this.init();
    }

    public JFormattedComboBox(E[] items) {
        super(items);
        this.init();
    }

    public JFormattedComboBox(Vector<E> items) {
        super(items);
        this.init();
    }

    private void init() {
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (label != null && value != null) {
                    label.setText(JFormattedComboBox.this.formatter.format(value));
                }
                return label;
            }
        });
    }

    public static interface Formatter {
        public String format(Object var1);
    }
}

