/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.jalbum.Icons;

public class JFileSelector
extends JPanel {
    protected String title;
    protected File selectedFile;
    protected File currentDirectory;
    protected FileNameExtensionFilter fileFilter;
    protected JTextComponent textComponent;
    protected JButton button = new JButton(Icons.small("open-folder"));
    protected boolean directories;
    protected boolean urlFormat = false;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JFileSelector.this.textComponentChanged();
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JFileSelector.this.textComponent != null) {
                if (evt.getPropertyName().equals("selectedFile")) {
                    JFileSelector.this.textComponent.getDocument().removeDocumentListener(JFileSelector.this.documentListener);
                    if (JFileSelector.this.urlFormat) {
                        try {
                            JFileSelector.this.textComponent.setText(JFileSelector.this.selectedFile.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        JFileSelector.this.textComponent.setText(JFileSelector.this.selectedFile.getAbsolutePath());
                    }
                    JFileSelector.this.textComponent.getDocument().addDocumentListener(JFileSelector.this.documentListener);
                } else if (evt.getPropertyName().equals("enabled")) {
                    JFileSelector.this.textComponent.setEnabled(JFileSelector.this.isEnabled());
                }
            }
        }
    };
    Vector listeners;

    public JFileSelector() {
        this("");
    }

    public JFileSelector(String title, boolean directories) {
        this.title = title;
        this.directories = directories;
        this.addPropertyChangeListener(this.propertyChangeListener);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JFileSelector(String title) {
        this(title, false);
    }

    public boolean isURLFormat() {
        return this.urlFormat;
    }

    public void setURLFormat(boolean urlFormat) {
        this.urlFormat = urlFormat;
    }

    private static File getFileFromPath(String path) {
        if (path.startsWith("file:")) {
            try {
                return new File(new URI(path));
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        } else if (path.startsWith("http:") || path.startsWith("https:")) {
            return null;
        }
        return new File(path);
    }

    protected void textComponentChanged() {
        this.removePropertyChangeListener(this.propertyChangeListener);
        this.setSelectedFile(JFileSelector.getFileFromPath(this.textComponent.getText()));
        this.addPropertyChangeListener(this.propertyChangeListener);
    }

    public JFileSelector(JTextComponent comp) {
        this("");
        this.setTextComponent(comp);
    }

    public JFileSelector(JTextComponent comp, boolean directories) {
        this("", directories);
        this.setTextComponent(comp);
    }

    public JFileSelector(String title, JTextComponent comp) {
        this(title);
        this.setTextComponent(comp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDirectories() {
        return this.directories;
    }

    public void setDirectories(boolean directories) {
        this.directories = directories;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public final void setTextComponent(JTextComponent textComponent) {
        if (textComponent != null) {
            textComponent.getDocument().removeDocumentListener(this.documentListener);
        }
        this.textComponent = textComponent;
        textComponent.setText(this.selectedFile != null ? this.selectedFile.getAbsolutePath() : "");
        textComponent.getDocument().addDocumentListener(this.documentListener);
        DropTarget dt = new DropTarget();
        textComponent.setDropTarget(new DropTarget(textComponent, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                e.acceptDrag(1);
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                e.acceptDrag(1);
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                if ((e.getSourceActions() & 1) == 0) {
                    e.rejectDrop();
                    return;
                }
                e.acceptDrop(1);
                try {
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e.dropComplete(true);
                    JFileSelector.this.setSelectedFile((File)files.get(0));
                    return;
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    System.err.println(ex);
                    e.dropComplete(false);
                    return;
                }
            }
        }));
    }

    @Override
    public String toString() {
        return this.selectedFile != null ? this.selectedFile.getAbsolutePath() : "";
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File selectedFile) {
        File oldFile = this.selectedFile;
        this.selectedFile = selectedFile;
        this.firePropertyChange("selectedFile", oldFile, selectedFile);
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public FileNameExtensionFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileNameExtensionFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    private void init() throws Exception {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.button.setMargin(new Insets(3, 3, 3, 3));
        this.button.addActionListener(e -> {
            DirectoryChooser chooser;
            int res = -1;
            if (this.directories) {
                chooser = ChooserFactory.createDirectoryChooser(SwingUtilities.getWindowAncestor(this));
            } else {
                FileChooser fc = ChooserFactory.createFileChooser(SwingUtilities.getWindowAncestor(this));
                chooser = fc;
                if (this.fileFilter != null) {
                    fc.setFileFilter(this.fileFilter);
                }
            }
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (this.selectedFile != null) {
                chooser.setCurrentDirectory(this.selectedFile.isDirectory() ? this.selectedFile : this.selectedFile.getParentFile());
                chooser.setSelectedFile(this.selectedFile);
            }
            chooser.setDialogTitle(this.title);
            res = chooser.showOpenDialog(this);
            if (res == 0) {
                this.setSelectedFile(chooser.getSelectedFile());
                this.fireActionOccured(new ActionEvent(this, 0, this.selectedFile.getAbsolutePath()));
            }
        });
        this.add((Component)this.button, "Center");
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }
}

