/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.File;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import se.datadosen.component.JSmartTextField;

public class JFilePathField
extends JSmartTextField {
    private File parentFile;
    private File file = new File("");
    private boolean hideText;

    public File getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(File parentFile) {
        this.parentFile = parentFile;
        this.repaint();
    }

    public JFilePathField(int chars) {
        super(chars);
        this.init();
    }

    private void init() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JFilePathField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JFilePathField.this.setText(JFilePathField.this.getText().trim());
                JFilePathField.this.repaint();
            }
        });
    }

    @Override
    protected Document createDefaultModel() {
        return new PlainDocument(){

            @Override
            public void getText(int offset, int length, Segment txt) throws BadLocationException {
                if (JFilePathField.this.hideText) {
                    super.getText(0, 0, txt);
                } else {
                    super.getText(offset, length, txt);
                }
            }
        };
    }

    @Override
    public void setText(String t) {
        this.file = new File(t);
        super.setText(t);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.hideText = !this.hasFocus();
        super.paintComponent(g);
        this.hideText = false;
        if (!this.hasFocus()) {
            LineMetrics lm;
            Rectangle2D rect;
            Object s;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = g.getFontMetrics();
            int offset = 0;
            if (this.parentFile != null && this.parentFile.isAbsolute() && !this.file.isAbsolute()) {
                g.setColor(Color.gray);
                s = this.parentFile.getAbsolutePath();
                if (!((String)s).endsWith(File.separator)) {
                    s = (String)s + File.separatorChar;
                }
                rect = fm.getStringBounds((String)s, g);
                offset = (int)rect.getWidth();
                lm = fm.getLineMetrics((String)s, g);
                g.drawString((String)s, 6, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            }
            g.setColor(this.getForeground());
            s = this.getText();
            rect = fm.getStringBounds((String)s, g);
            lm = fm.getLineMetrics((String)s, g);
            g.drawString((String)s, 6 + offset, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
        }
    }
}

