/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.jalbum.util.Animator;
import se.datadosen.component.JWorkFlow;
import se.datadosen.jalbum.JAlbumColor;

public class JFadingText
extends JComponent {
    private String text;
    private JComponent refComp;
    private float alpha = 1.0f;
    private Animator.Control animControl;
    private static JLabel dummyLabel = new JLabel();
    private Rectangle2D stringBounds;

    public JFadingText(String text, JComponent refComp) {
        this.text = " " + text + " ";
        this.refComp = refComp;
        this.setFont(dummyLabel.getFont().deriveFont(0, 40.0f));
        this.setForeground(JAlbumColor.textText);
        this.setBackground(JAlbumColor.control);
        this.setDoubleBuffered(false);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (this.getGraphics() != null) {
            this.repaint(this.getRealBounds());
        }
    }

    Rectangle getRealBounds() {
        if (this.stringBounds == null) {
            Graphics g = this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            this.stringBounds = metrics.getStringBounds(this.text, g);
        }
        double w = Math.max(this.stringBounds.getWidth(), this.stringBounds.getHeight());
        int side = (int)(w * 1.2);
        Point compLoc = this.getLocationRelativeLayeredPane(this.refComp);
        Dimension compSize = this.refComp.getSize();
        return new Rectangle(compLoc.x + (compSize.width - side) / 2, compLoc.y + (compSize.height - side) / 2, side, side);
    }

    private void animate() {
        if (this.animControl != null) {
            this.animControl.abort();
        }
        if (this.isShowing() && this.refComp.isShowing()) {
            this.animControl = Animator.getInstance().playFor(2000, ctrl -> {
                if (!this.isVisible() || !this.refComp.isShowing()) {
                    ctrl.abort();
                    return;
                }
                this.setAlpha(1.0f - ctrl.getCurrentTimeNormalized());
                Rectangle bounds = this.getRealBounds();
                this.repaint(bounds);
            }).setCycleCount(1);
            this.animControl.onDone(() -> {
                this.setVisible(false);
                this.uninstall();
                this.refComp.repaint();
            });
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        if (this.animControl == null || this.animControl.isAborted()) {
            this.animate();
        }
        Graphics2D g = (Graphics2D)g2d.create();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (!this.refComp.isShowing()) {
            return;
        }
        Rectangle bounds = this.getRealBounds();
        Rectangle2D sb = this.stringBounds;
        g.translate(bounds.x, bounds.y);
        AlphaComposite composite = AlphaComposite.getInstance(3, this.alpha);
        g.setComposite(composite);
        g.setColor(this.getBackground());
        g.fillRoundRect((int)(((double)bounds.width - sb.getWidth()) / 2.0 - sb.getX()), (int)(((double)bounds.width - sb.getHeight()) / 2.0), (int)sb.getWidth(), (int)sb.getHeight(), (int)sb.getHeight(), (int)sb.getHeight());
        g.setColor(this.getForeground());
        g.drawString(this.text, (float)(((double)bounds.width - sb.getWidth()) / 2.0 - sb.getX()), (float)(((double)bounds.height - sb.getHeight()) / 2.0 - sb.getY()));
        g.dispose();
    }

    Point getLocationRelativeLayeredPane(JComponent comp) {
        JLayeredPane layeredPane = JWorkFlow.getLayeredPane(SwingUtilities.getWindowAncestor(comp));
        return SwingUtilities.convertPoint(comp.getParent(), comp.getLocation(), layeredPane);
    }

    public void install(final Window window) {
        this.setBounds(SwingUtilities.getLocalBounds(window));
        window.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ JFadingText this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.this$0.setBounds(SwingUtilities.getLocalBounds(window));
            }
        });
        JFadingText.getLayeredPane(window).add((Component)this, JLayeredPane.DRAG_LAYER);
        JFadingText.getLayeredPane(window).validate();
    }

    public void uninstall() {
        Window window = SwingUtilities.getWindowAncestor(this.refComp);
        JFadingText.getLayeredPane(window).remove(this);
        JFadingText.getLayeredPane(window).validate();
    }

    static JLayeredPane getLayeredPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getLayeredPane();
        }
        throw new IllegalArgumentException("window not of Swing type");
    }
}

