/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.jalbum.util.Animator;

public class JFadePanel
extends JPanel {
    private float alpha = 1.0f;
    private boolean dimmed;

    public JFadePanel() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
    }

    public JFadePanel(JComponent content) {
        this();
        this.add(content);
    }

    public JFadePanel(LayoutManager mgr) {
        super(mgr);
        this.setOpaque(false);
    }

    public boolean isDimmed() {
        return this.dimmed;
    }

    public void setDimmed(boolean dimmed) {
        boolean oldDimmed = this.dimmed;
        this.dimmed = dimmed;
        this.repaint();
        this.firePropertyChange("dimmed", oldDimmed, dimmed);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() && visible) {
            return;
        }
        if (visible) {
            this.alpha = 0.0f;
        }
        super.setVisible(visible);
        if (visible) {
            Animator.getInstance().playFor(250, ctrl -> {
                if (!this.isVisible()) {
                    ctrl.abort();
                    return;
                }
                this.alpha = ctrl.getCurrentTimeNormalized();
                this.repaint();
            });
        }
    }

    @Override
    protected void paintChildren(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        float a = this.dimmed ? this.alpha * 0.5f : this.alpha;
        AlphaComposite composite = AlphaComposite.getInstance(3, a);
        g.setComposite(composite);
        super.paintChildren(g);
    }

    public void doPaintChildren(Graphics g2d) {
        this.paintChildren(g2d);
    }
}

