/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import se.datadosen.component.DirectoryChooser;

public class JDirectoryChooser
extends JFileChooser
implements DirectoryChooser {
    private Component parent;

    public JDirectoryChooser() {
        this.setFileSelectionMode(1);
    }

    public JDirectoryChooser(File startDir) {
        super(startDir);
        this.setFileSelectionMode(1);
    }

    public JDirectoryChooser(Window parent, File startDir) {
        super(startDir);
        this.setFileSelectionMode(1);
        this.parent = parent;
    }

    public JDirectoryChooser(Window parent) {
        this.setFileSelectionMode(1);
        this.parent = parent;
    }

    @Override
    public File getSelectedFile() {
        String fileSep;
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String dirName = super.getSelectedFile().getAbsolutePath();
        if (dirName.endsWith((fileSep = System.getProperty("file.separator", "\\")) + ".")) {
            dirName = dirName.substring(0, dirName.length() - 1);
            file = new File(dirName);
        }
        return file;
    }

    @Override
    public void setCurrentDirectory(File file) {
        super.setCurrentDirectory(file);
        FileChooserUI ui = this.getUI();
        if (ui instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)ui).setFileName(".");
        }
    }

    public int showChooser() {
        return this.showOpenDialog(this.parent);
    }
}

