/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import se.datadosen.util.Item;

public class JComboMenu
extends JMenu {
    private Item[] items = new Item[0];
    private ButtonGroup group;

    public JComboMenu(String text) {
        super(text);
    }

    public JComboMenu(Item ... items) {
        this.setItems(items);
    }

    public JComboMenu(String text, Item ... items) {
        super(text);
        this.setItems(items);
    }

    public void setItems(Item[] items) {
        this.items = items;
        this.removeAll();
        this.group = new ButtonGroup();
        for (Item item : items) {
            JRadioButtonMenuItem choice = new JRadioButtonMenuItem(item.item.toString());
            choice.setActionCommand(item.value.toString());
            this.group.add(choice);
            choice.addActionListener(ae -> this.fireActionPerformed(ae));
            this.add(choice);
        }
    }

    public Item getSelectedItem() {
        String key = this.group.getSelection().getActionCommand();
        for (Item item : this.items) {
            if (!item.value.equals(key)) continue;
            return item;
        }
        return null;
    }

    public void setSelectedItem(Item item) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JRadioButtonMenuItem choice = (JRadioButtonMenuItem)this.getItem(i);
            if (!choice.getActionCommand().equals(item.value)) continue;
            choice.setSelected(true);
            this.fireItemStateChanged(new ItemEvent(this, 701, item, 1));
        }
    }
}

