/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.JAlphaColorSelector;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected String title;
    protected Color color = Color.black;
    private TexturePaint disabledColor;
    protected JTextField textComponent;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JColorSelector.this.textComponent != null) {
                if (evt.getPropertyName().equals("color")) {
                    JColorSelector.this.textComponent.getDocument().removeDocumentListener(JColorSelector.this.documentListener);
                    JColorSelector.this.textComponent.setText(JColorSelector.this.getHTMLColor());
                    JColorSelector.this.textComponent.getDocument().addDocumentListener(JColorSelector.this.documentListener);
                } else if (evt.getPropertyName().equals("enabled")) {
                    JColorSelector.this.textComponent.setEnabled(JColorSelector.this.isEnabled());
                }
            }
        }
    };
    Vector listeners;
    private final int Y_OFFSET = 1;

    public JColorSelector() {
        this("");
    }

    public JColorSelector(String title) {
        this.title = title;
        this.addPropertyChangeListener(this.propertyChangeListener);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void textComponentChanged() {
        this.removePropertyChangeListener(this.propertyChangeListener);
        this.setColor(this.textComponent.getText(), false);
        this.addPropertyChangeListener(this.propertyChangeListener);
    }

    public JColorSelector(JTextField comp) {
        this("");
        this.setTextComponent(comp);
    }

    public JColorSelector(String title, JTextField comp) {
        this(title);
        this.setTextComponent(comp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public JTextField getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(JTextField textComponent) {
        if (textComponent != null) {
            textComponent.getDocument().removeDocumentListener(this.documentListener);
        }
        this.textComponent = textComponent;
        textComponent.setText(this.getHTMLColor());
        textComponent.getDocument().addDocumentListener(this.documentListener);
    }

    public String getHTMLColor() {
        return Colors.toHTMLColor(this.color);
    }

    @Override
    public String toString() {
        return this.getHTMLColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String htmlColor) {
        this.setColor(htmlColor, true);
    }

    void setColor(String htmlColor, boolean detectOldAlphaFormat) {
        try {
            this.setColor(Colors.getHTMLColor(htmlColor));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = this.stripAlpha(color);
        this.disabledColor = this.createDisabledColor(this.color);
        this.repaint();
        this.firePropertyChange("color", oldColor, this.getHTMLColor());
    }

    private TexturePaint createDisabledColor(Color c) {
        int s = 20;
        BufferedImage im = new BufferedImage(s, s, 6);
        Graphics2D g = im.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c);
        g.setStroke(new BasicStroke(2.0f));
        for (int i = -s; i <= s; i += 6) {
            g.drawLine(0 + i, 0, s + i, s);
        }
        g.dispose();
        return new TexturePaint(im, new Rectangle(0, 0, s, s));
    }

    public static Color showDialog(Component component, String title, Color initialColor, boolean colorTransparencySelectionEnabled) throws HeadlessException {
        JColorChooser pane = new JColorChooser();
        AbstractColorChooserPanel[] panels = pane.getChooserPanels();
        try {
            for (AbstractColorChooserPanel ccPanel : panels) {
                ccPanel.setColorTransparencySelectionEnabled(colorTransparencySelectionEnabled);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        pane.removeChooserPanel(panels[0]);
        pane.addChooserPanel(panels[0]);
        pane.setColor(64, 1, 128);
        ColorTracker ok = new ColorTracker(pane);
        pane.setColor(initialColor != null ? initialColor : Color.white);
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addComponentListener(new DisposeOnClose());
        dialog.setVisible(true);
        return ok.getColor();
    }

    private void init() throws Exception {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(20, 15 + this.Y_OFFSET));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorSelector.showDialog(JColorSelector.this, JColorSelector.this.title, JColorSelector.this.color, JColorSelector.this instanceof JAlphaColorSelector);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                    JColorSelector.this.fireActionOccured(new ActionEvent(JColorSelector.this, 0, JColorSelector.this.getHTMLColor()));
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isEnabled() || this.disabledColor == null) {
            g.setColor(this.color.brighter());
            g.fillRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
            g.setColor(this.color);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g.setPaint(this.disabledColor);
        }
        g.fillRoundRect(1, this.Y_OFFSET + 1, w - 2, h - this.Y_OFFSET - 2, 0, 0);
        g.setColor(this.color.darker());
        g.drawRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
    }

    private Color stripAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser paramJColorChooser) {
            this.chooser = paramJColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }
}

