/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.border.Border;
import se.datadosen.jalbum.JAlbumUtilities;

public class JBackgroundPanel
extends JPanel {
    protected Image bg;
    protected Border imageBorder;
    private Rectangle bounds = new Rectangle();
    private Future imageFuture;
    protected double scaleFactor = 1.0;

    public int getImageTopCornerXCoordinate() {
        return this.bounds.x;
    }

    public int getImageTopCornerYCoordinate() {
        return this.bounds.y;
    }

    public Rectangle getImageBounds() {
        return this.bounds;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setBackgroundImage(Image bg) {
        if (this.imageFuture != null && !this.imageFuture.isDone()) {
            this.imageFuture.cancel(true);
        }
        this.bg = bg;
        this.repaint();
    }

    public void setBackgroundImageAsync(Callable<Image> task) {
        if (this.imageFuture != null && !this.imageFuture.isDone()) {
            this.imageFuture.cancel(true);
        }
        this.imageFuture = JAlbumUtilities.schedule(() -> {
            try {
                Image im = (Image)task.call();
                if (!Thread.currentThread().isInterrupted()) {
                    this.bg = im;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 300L, TimeUnit.MILLISECONDS);
    }

    public Image getBackgroundImage() {
        return this.bg;
    }

    public Dimension getDisplayableImageSize() {
        Dimension size = (Dimension)this.getSize().clone();
        return size;
    }

    public void setImageBorder(Border border) {
        this.imageBorder = border;
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (this.bg != null) {
            int iw = this.bg.getWidth(null);
            int ih = this.bg.getHeight(null);
            int cw = this.getWidth();
            int ch = this.getHeight();
            Insets in = this.getInsets();
            Insets in2 = new Insets(0, 0, 0, 0);
            if (this.imageBorder != null) {
                in2 = this.imageBorder.getBorderInsets(this);
            }
            int boundingWidth = cw - in.left - in2.left - in.right - in2.right;
            int boundingHeight = ch - in.top - in2.top - in.bottom - in2.bottom;
            Dimension scaledDim = this.calcDimension(iw, ih, new Dimension(boundingWidth, boundingHeight));
            iw = scaledDim.width;
            ih = scaledDim.height;
            int ix = (cw - iw) / 2;
            int iy = (ch - ih) / 2;
            this.bounds.setBounds(ix, iy, iw, ih);
            g.drawImage(this.bg, ix, iy, iw, ih, null);
            if (this.imageBorder != null) {
                this.imageBorder.paintBorder(this, g, ix - in2.left, iy - in2.top, iw + in2.left + in2.right, ih + in2.top + in2.bottom);
            }
        }
    }

    private Dimension calcDimension(int width, int height, Dimension boundingBox) {
        double maxScale;
        if (width <= boundingBox.width && height <= boundingBox.height) {
            this.scaleFactor = 1.0;
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        this.scaleFactor = maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }
}

