/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;
import javax.swing.UIManager;
import se.datadosen.component.JColorSelector;

public class JAlphaColorSelector
extends JColorSelector {
    protected TexturePaint disabledColor = null;
    protected int cornerRadius = 8;

    public JAlphaColorSelector(String title, JTextField comp) {
        super(title, comp);
        this.init();
    }

    public JAlphaColorSelector(JTextField comp) {
        super(comp);
        this.init();
    }

    public JAlphaColorSelector(String title) {
        super(title);
        this.init();
    }

    public JAlphaColorSelector() {
        this.init();
    }

    @Override
    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.repaint();
        this.firePropertyChange("color", oldColor, this.getHTMLColor());
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.disabledColor = null;
        this.repaint();
    }

    @Override
    public String getHTMLColor() {
        return JAlphaColorSelector.toHexValue(this.color);
    }

    @Override
    public void setColor(String htmlColor) {
        try {
            if (htmlColor != null && htmlColor.length() > 0 && htmlColor.charAt(0) == '#') {
                this.setColor(JAlphaColorSelector.fromHexValue(htmlColor));
            } else {
                super.setColor(htmlColor);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d;
        int w = this.getWidth();
        int h = this.getHeight();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.clip(new RoundRectangle2D.Double(0.0, 0.0, w, h, this.cornerRadius, this.cornerRadius));
        g.setColor(Color.black);
        g.fillRect(0, 0, w / 2, h / 2);
        g.fillRect(w / 2, h / 2, w, h);
        g.setColor(this.color);
        g.fillRect(0, 0, w, h);
        if (!this.isEnabled()) {
            g.setPaint(this.getDisabledColor());
            g.fillRect(0, 0, w, h);
        }
        g.setClip(null);
        g.setColor(this.isEnabled() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
        g.drawRoundRect(0, 0, w - 1, h - 1, this.cornerRadius, this.cornerRadius);
    }

    private TexturePaint createDisabledColor(Color c) {
        int s = 100;
        BufferedImage im = new BufferedImage(s, s, 6);
        Graphics2D g = im.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c);
        g.setStroke(new BasicStroke(2.0f));
        for (int i = -s; i <= s; i += 6) {
            g.drawLine(0 + i, 0, s + i, s);
        }
        g.dispose();
        return new TexturePaint(im, new Rectangle(0, 0, s, s));
    }

    private void init() {
        this.setPreferredSize(new Dimension(24, 20));
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
        this.repaint();
    }

    public String toRGBAString() {
        return JAlphaColorSelector.toRGBAString(this.color);
    }

    public String toRGBString() {
        return JAlphaColorSelector.toRGBString(this.color);
    }

    public static String toRGBAString(String hexColor) {
        try {
            return JAlphaColorSelector.toRGBAString(JAlphaColorSelector.fromHexValue(hexColor));
        }
        catch (Exception ex) {
            System.err.println(ex);
            return JAlphaColorSelector.toRGBAString(Color.black);
        }
    }

    public static String toRGBString(String hexColor) {
        try {
            return JAlphaColorSelector.toRGBString(JAlphaColorSelector.fromHexValue(hexColor));
        }
        catch (Exception ex) {
            System.err.println(ex);
            return JAlphaColorSelector.toRGBString(Color.black);
        }
    }

    public static String toRGBAString(Color c) {
        StringBuilder sb = new StringBuilder();
        sb.append("rgba(");
        sb.append(c.getRed());
        sb.append(',');
        sb.append(c.getGreen());
        sb.append(',');
        sb.append(c.getBlue());
        sb.append(',');
        sb.append((float)c.getAlpha() / 255.0f);
        sb.append(')');
        return sb.toString();
    }

    public static String toRGBString(Color c) {
        if (c.getAlpha() == 0) {
            return "transparent";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("rgb(");
        sb.append(c.getRed());
        sb.append(',');
        sb.append(c.getGreen());
        sb.append(',');
        sb.append(c.getBlue());
        sb.append(')');
        return sb.toString();
    }

    protected static String toHexValue(Color c) {
        int value = c.getRGB();
        value &= 0xFFFFFF;
        return "#" + JAlphaColorSelector.leftPad(Integer.toHexString(value |= c.getAlpha() << 24), '0', 8);
    }

    private static String leftPad(String s, char c, int n) {
        if (s.length() >= n) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n - s.length(); ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }

    protected static Color fromHexValue(String hexColor) {
        if (hexColor == null || hexColor.length() == 0) {
            throw new IllegalArgumentException("Cannot convert '" + hexColor + "' to a Color");
        }
        if (hexColor.length() < 8) {
            return new Color(Integer.parseInt(hexColor.substring(1), 16));
        }
        return new Color((int)Long.parseLong(hexColor.substring(1), 16), true);
    }

    private Paint getDisabledColor() {
        if (this.disabledColor == null) {
            this.disabledColor = this.createDisabledColor(this.getBackground());
        }
        return this.disabledColor;
    }
}

