/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.stage.FileChooser;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;

class FXFileChooser
implements FileChooser {
    public static final boolean FX_AVAILABLE;
    private ActionListener listener;
    private int fileSelectionMode = 0;
    private String title;
    private File[] selectedFiles;
    private File currentDirectory;
    private FileFilter fileFilter;
    private int dialogType = 0;
    private boolean multiSelectionEnabled;
    private JDialog modal;
    private Object chooser = null;

    FXFileChooser() {
    }

    public static FileChooser createFileChooser() {
        return new FXFileChooser();
    }

    public static FileChooser createFilesChooser() {
        FXFileChooser chooser = new FXFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        return chooser;
    }

    public static DirectoryChooser createDirectoryChooser() {
        FXFileChooser chooser = new FXFileChooser();
        chooser.setFileSelectionMode(1);
        return chooser;
    }

    @Override
    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionEnabled = b;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    @Override
    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    @Override
    public void setFileView(FileView fileView) {
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        this.fileFilter = filter;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.chooser = null;
        this.modal = new JDialog(parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent), Dialog.ModalityType.APPLICATION_MODAL);
        this.modal.setUndecorated(true);
        this.modal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FXFileChooser.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (FXFileChooser.this.chooser == null) {
                    Platform.runLater((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            FXFileChooser.this.currentDirectory = this.ensureExists(FXFileChooser.this.currentDirectory);
                            try {
                                javafx.stage.DirectoryChooser chooser;
                                if (FXFileChooser.this.fileSelectionMode == 1) {
                                    chooser = new javafx.stage.DirectoryChooser();
                                    FXFileChooser.this.chooser = chooser;
                                    chooser.setTitle(FXFileChooser.this.title);
                                    chooser.setInitialDirectory(FXFileChooser.this.currentDirectory);
                                    File f = FXFileChooser.this.getSelectedFile();
                                    if (f != null && f.isDirectory()) {
                                        chooser.setInitialDirectory(f);
                                    }
                                    FXFileChooser.this.setSelectedFile(chooser.showDialog(null));
                                    FXFileChooser.this.setCurrentDirectory(chooser.getInitialDirectory());
                                } else {
                                    chooser = new javafx.stage.FileChooser();
                                    FXFileChooser.this.chooser = chooser;
                                    chooser.setTitle(FXFileChooser.this.title);
                                    chooser.setInitialDirectory(FXFileChooser.this.currentDirectory);
                                    File f = FXFileChooser.this.getSelectedFile();
                                    if (f != null && f.isFile()) {
                                        chooser.setInitialFileName(f.getName());
                                    }
                                    if (FXFileChooser.this.fileFilter instanceof FileNameExtensionFilter) {
                                        FileNameExtensionFilter extFilter = (FileNameExtensionFilter)FXFileChooser.this.fileFilter;
                                        ArrayList<String> ext = new ArrayList<String>();
                                        for (String extension : extFilter.getExtensions()) {
                                            ext.add(extension.replaceAll("^\\*?\\.?(.*)$", "*.$1"));
                                        }
                                        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(extFilter.getDescription(), ext));
                                    }
                                    if (FXFileChooser.this.dialogType == 1) {
                                        FXFileChooser.this.setSelectedFile(chooser.showSaveDialog(null));
                                    } else if (FXFileChooser.this.isMultiSelectionEnabled()) {
                                        List files = chooser.showOpenMultipleDialog(null);
                                        if (files != null) {
                                            FXFileChooser.this.selectedFiles = files.toArray(new File[files.size()]);
                                        }
                                    } else {
                                        FXFileChooser.this.setSelectedFile(chooser.showOpenDialog(null));
                                    }
                                }
                                File sel = FXFileChooser.this.getSelectedFile();
                                if (sel != null) {
                                    FXFileChooser.this.setCurrentDirectory(sel.isDirectory() ? sel : sel.getParentFile());
                                }
                            }
                            finally {
                                FXFileChooser.this.modal.setVisible(false);
                            }
                        }

                        private File ensureExists(File dir) {
                            while (dir != null && !dir.exists()) {
                                dir = dir.getParentFile();
                            }
                            return dir;
                        }
                    });
                } else if (FXFileChooser.this.selectedFiles == null) {
                    FXFileChooser.this.modal.toBack();
                }
            }
        });
        this.modal.setVisible(true);
        if (this.selectedFiles != null) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
            }
            return 0;
        }
        return 1;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, "Ok");
    }

    @Override
    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            this.selectedFiles = new File[1];
            this.selectedFiles[0] = file;
            this.setCurrentDirectory(file.getParentFile());
        } else {
            this.selectedFiles = null;
        }
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFiles != null && this.selectedFiles.length > 0 ? this.selectedFiles[0] : null;
    }

    @Override
    public void setDialogTitle(String title) {
        this.title = title;
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.setDialogType(0);
        return this.showDialog(parent, "Ok");
    }

    static {
        boolean isFx;
        try {
            Class.forName("javafx.stage.FileChooser");
            isFx = true;
            JFXPanel jFXPanel = new JFXPanel();
        }
        catch (ClassNotFoundException e) {
            isFx = false;
        }
        FX_AVAILABLE = isFx;
    }
}

