/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class DropZoneBorder
implements Border {
    private int radius = 8;
    private float lineWeight = 2.0f;
    private Color lineColor;
    private static final double COS45 = 1.0 / Math.sqrt(2.0);

    public DropZoneBorder() {
    }

    public DropZoneBorder(Color lineColor) {
        this.lineColor = lineColor;
    }

    public DropZoneBorder(int radius) {
        this.radius = radius;
    }

    public DropZoneBorder(int radius, int lineWeight) {
        this.radius = radius;
        this.lineWeight = lineWeight;
    }

    @Override
    public void paintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g1.create();
        g.translate(0.5, 0.5);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
        } else {
            g.setColor(c.getForeground());
        }
        BasicStroke dashed = new BasicStroke(this.lineWeight, 0, 0, 4.0f, new float[]{8.0f, 4.0f}, 0.0f);
        g.setStroke(dashed);
        int m = (int)(((double)this.lineWeight + 0.5) / 2.0);
        g.drawRoundRect(x + m, y + m, width - 2 * m - 1, height - 2 * m - 1, this.radius * 2, this.radius * 2);
        g.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int lineWeightSpace = (int)((double)this.lineWeight + 0.5);
        double h = Math.sqrt(2 * this.radius * this.radius);
        double a = h - (double)this.radius;
        double x = a * COS45;
        int radiusSpace = (int)(x + (double)this.lineWeight * COS45);
        int m = Math.max(lineWeightSpace, radiusSpace);
        return new Insets(m, m, m, m);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

