/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import se.datadosen.jalbum.JAlbumColor;

public class DropDownIcon
implements Icon {
    private static Color arrowColor = UIManager.getColor("ArrowButton.arrowColor");

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        JComponent c = (JComponent)component;
        int w = this.getIconWidth() - 2;
        int h = this.getIconHeight();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform backup = g2d.getTransform();
        g.translate(x + 1, y);
        g.setColor(c.isEnabled() ? arrowColor : JAlbumColor.textInactiveText);
        int[] xs = new int[]{0, w, w / 2};
        int[] ys = new int[]{0, 0, h};
        g.fillPolygon(xs, ys, xs.length);
        g2d.setTransform(backup);
    }

    @Override
    public int getIconWidth() {
        return 10;
    }

    @Override
    public int getIconHeight() {
        return 4;
    }

    static {
        if (arrowColor == null) {
            arrowColor = JAlbumColor.textText;
        }
    }
}

