/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.SVGLoader;
import com.github.weisj.jsvg.view.FloatSize;
import com.github.weisj.jsvg.view.ViewBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import net.jalbum.util.Profiler;
import se.datadosen.component.SVGIcon;
import se.datadosen.util.LaF;
import se.datadosen.util.Replacer;

public class DeferredJSVGIcon
extends ImageIcon
implements SVGIcon {
    private final Class<?> resourceLoader;
    private final String name;
    private boolean adaptColors = true;
    private boolean invertColors = false;
    private int naturalWidth = 0;
    private int naturalHeight = 0;
    private int iconWidth = -1;
    private int iconHeight = -1;
    private SoftReference<Image> image = new SoftReference<Object>(null);
    private static final Map<String, SVGDocument> CACHE = new ConcurrentHashMap<String, SVGDocument>();
    private static final SVGLoader SHARED_LOADER = new SVGLoader();
    private static final LoaderContext CONTEXT = LoaderContext.builder().build();
    private static final Replacer COLOR_REPLACER = new Replacer();

    public DeferredJSVGIcon(Class<?> resourceLoader, String name) {
        this.resourceLoader = resourceLoader;
        this.name = name;
    }

    @Override
    public boolean isAdaptColors() {
        return this.adaptColors;
    }

    @Override
    public void setAdaptColors(boolean adaptColors) {
        this.adaptColors = adaptColors;
    }

    @Override
    public boolean isInvertColors() {
        return this.invertColors;
    }

    @Override
    public void setInvertColors(boolean invertColors) {
        this.invertColors = invertColors;
    }

    public void setIconSize(int width, int height) {
        this.iconWidth = width;
        this.iconHeight = height;
    }

    @Override
    public int getIconWidth() {
        this.ensureLoaded();
        return this.iconWidth > 0 ? this.iconWidth : this.naturalWidth;
    }

    @Override
    public int getIconHeight() {
        this.ensureLoaded();
        return this.iconHeight > 0 ? this.iconHeight : this.naturalHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        SVGDocument svgDoc = this.getSvgDoc();
        if (svgDoc != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(x, y);
            svgDoc.render(c, g2d, new ViewBox(0.0f, 0.0f, (float)this.getIconWidth(), (float)this.getIconHeight()));
            g2d.dispose();
        }
    }

    private String cacheKey() {
        return this.invertColors || LaF.isDark() && this.adaptColors ? this.name + "_dark" : this.name + "_normal";
    }

    protected byte[] loadIconBytes() throws IOException {
        try (InputStream is = this.resourceLoader.getResourceAsStream(this.name);){
            if (is == null) {
                throw new MissingResourceException("Can't locate icon \"" + this.name + "\"", this.resourceLoader.getName(), this.name);
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    private void ensureLoaded() {
        SVGDocument svgDoc = this.getSvgDoc();
        if (svgDoc != null) {
            FloatSize size = svgDoc.size();
            this.naturalWidth = (int)size.getWidth();
            this.naturalHeight = (int)size.getHeight();
            if (this.iconWidth <= 0) {
                this.iconWidth = this.naturalWidth;
            }
            if (this.iconHeight <= 0) {
                this.iconHeight = this.naturalHeight;
            }
            return;
        }
        try (Profiler.Sample _s = Profiler.profile("Icon loading");){
            ByteArrayInputStream bais;
            SVGDocument cached = CACHE.get(this.cacheKey());
            if (cached != null) {
                return;
            }
            byte[] bytes = this.loadIconBytes();
            if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
                bytes = Arrays.copyOfRange(bytes, 3, bytes.length);
            }
            String svgText = new String(bytes, StandardCharsets.UTF_8);
            if (this.invertColors || LaF.isDark() && this.adaptColors) {
                svgText = COLOR_REPLACER.replace(svgText);
            }
            if ((svgDoc = SHARED_LOADER.load((InputStream)(bais = new ByteArrayInputStream(svgText.getBytes(StandardCharsets.UTF_8))), null, CONTEXT)) == null) {
                throw new MissingResourceException("Failed to parse SVG icon (document is null): " + this.name, this.resourceLoader.getName(), this.name);
            }
            FloatSize size = svgDoc.size();
            this.naturalWidth = (int)size.getWidth();
            this.naturalHeight = (int)size.getHeight();
            if (this.iconWidth <= 0) {
                this.iconWidth = this.naturalWidth;
            }
            if (this.iconHeight <= 0) {
                this.iconHeight = this.naturalHeight;
            }
            CACHE.put(this.cacheKey(), svgDoc);
        }
        catch (IOException e) {
            throw new MissingResourceException("Error reading SVG icon: " + this.name + " (" + e.getMessage() + ")", this.resourceLoader.getName(), this.name);
        }
    }

    private SVGDocument getSvgDoc() {
        return CACHE.get(this.cacheKey());
    }

    private BufferedImage renderSvg(int width, int height) {
        this.ensureLoaded();
        SVGDocument svgDoc = this.getSvgDoc();
        if (svgDoc != null) {
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            svgDoc.render(null, g2d, new ViewBox(0.0f, 0.0f, (float)width, (float)height));
            g2d.dispose();
            return bi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage() {
        Image im = this.image.get();
        if (im == null) {
            DeferredJSVGIcon deferredJSVGIcon = this;
            synchronized (deferredJSVGIcon) {
                if (this.image.get() == null) {
                    int w = this.getIconWidth();
                    int h = this.getIconHeight();
                    BufferedImage small = this.renderSvg(w, h);
                    BufferedImage large = this.renderSvg(w * 2, h * 2);
                    im = new BaseMultiResolutionImage(small, large);
                    this.image = new SoftReference<Image>(im);
                }
            }
        }
        return im;
    }

    @Override
    public String toString() {
        return "DeferredJSVGIcon: " + this.name;
    }

    @Override
    public DeferredJSVGIcon cloneMe() {
        DeferredJSVGIcon clone = new DeferredJSVGIcon(this.resourceLoader, this.name);
        clone.adaptColors = this.adaptColors;
        clone.invertColors = this.invertColors;
        clone.iconWidth = this.iconWidth;
        clone.iconHeight = this.iconHeight;
        clone.naturalWidth = this.naturalWidth;
        clone.naturalHeight = this.naturalHeight;
        clone.image = this.image;
        return clone;
    }

    static {
        COLOR_REPLACER.add("#333333", "#DDDDDD");
        COLOR_REPLACER.add("#333", "#DDD");
        COLOR_REPLACER.add("#DDDDDD", "#333333");
        COLOR_REPLACER.add("#DDD", "#333");
        COLOR_REPLACER.add("#000000", "#FFFFFF");
        COLOR_REPLACER.add("#000", "#FFF");
        COLOR_REPLACER.add("#FFFFFF", "#000000");
        COLOR_REPLACER.add("#FFF", "#000");
        COLOR_REPLACER.add("#165FB1", "#589df6");
    }
}

