/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Point;
import java.text.SimpleDateFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.text.JTextComponent;
import se.datadosen.component.StateMonitor;

public class DatePatternVerifier
extends InputVerifier {
    PopupFactory popupFactory = PopupFactory.getSharedInstance();
    Popup popup;

    public DatePatternVerifier(final JTextComponent comp) {
        comp.setInputVerifier(this);
        new StateMonitor(this){
            final /* synthetic */ DatePatternVerifier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChange() {
                this.this$0.verify(comp);
            }
        }.add(comp);
    }

    @Override
    public boolean verify(JComponent input) {
        JTextComponent comp = (JTextComponent)input;
        try {
            new SimpleDateFormat(comp.getText());
            this.resetPopup();
            return true;
        }
        catch (IllegalArgumentException ex) {
            this.showToolTip(comp, ex.getMessage());
            return false;
        }
    }

    private void showToolTip(JComponent component, String tip) {
        Point p = component.getLocationOnScreen();
        this.showToolTip(component, tip, p.x + 20, p.y - 14);
    }

    private void showToolTip(JComponent component, String tip, int x, int y) {
        this.resetPopup();
        JToolTip tooltip = component.createToolTip();
        tooltip.setTipText(tip);
        tooltip.setBackground(new Color(255, 100, 100));
        this.popup = this.popupFactory.getPopup(component, tooltip, x, y);
        this.popup.show();
    }

    private void resetPopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }
}

