/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.adapter.JavaBeanBooleanPropertyBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.ManagesImport;
import se.datadosen.util.Platform;

public class ControlPanel
extends JPanel
implements JComponentHolder,
ManagesImport {
    private boolean useExtraSpace = true;
    private BooleanProperty enabledProperty;

    public ControlPanel() {
        super(new RiverLayout());
        try {
            this.enabledProperty = JavaBeanBooleanPropertyBuilder.create().bean((Object)this).name("enabled").build();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        this.setBorder(null);
        this.transparentize(this);
    }

    public ControlPanel(LayoutManager layout) {
        super(layout);
        try {
            this.enabledProperty = JavaBeanBooleanPropertyBuilder.create().bean((Object)this).name("enabled").build();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        this.setBorder(null);
        this.transparentize(this);
    }

    public ControlPanel(String title) {
        this();
        this.setTitle(title);
    }

    public BooleanProperty enabledProperty() {
        return this.enabledProperty;
    }

    public String getTitle() {
        TitledBorder tb = this.getTitledBorder();
        return tb != null ? tb.getTitle() : null;
    }

    public void setTitle(String title) {
        this.setBorder(this.createControlPanelBorder(title));
    }

    public void setText(String title) {
        this.setTitle(title);
    }

    private Border createControlPanelBorder(String title) {
        if (title.length() <= 0) {
            return null;
        }
        return JAlbumBorders.createTitledCurveBorder(title, this.useExtraSpace);
    }

    public TitledBorder getTitledBorder() {
        if (this.getBorder() instanceof CompoundBorder) {
            TitledBorder tb = (TitledBorder)((CompoundBorder)this.getBorder()).getInsideBorder();
            if (tb.getTitleFont() == null) {
                Font f = new JLabel("").getFont();
                tb.setTitleFont(f);
            }
            return tb;
        }
        if (this.getBorder() instanceof TitledBorder) {
            return (TitledBorder)this.getBorder();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enable) {
        Component[] comps;
        super.setEnabled(enable);
        try {
            if (this.getBorder() != null) {
                ((TitledBorder)((CompoundBorder)this.getBorder()).getInsideBorder()).setTitleColor(enable ? JAlbumColor.textText : JAlbumColor.textInactiveText);
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        for (Component comp : comps = this.getComponents()) {
            comp.setEnabled(enable);
            if (!(comp instanceof JScrollPane)) continue;
            ((JScrollPane)comp).getViewport().getView().setEnabled(enable);
        }
    }

    @Override
    public void add(Component c, Object o) {
        this.transparentize(c);
        super.add(c, o);
    }

    @Override
    public Component add(String s, Component c) {
        this.transparentize(c);
        return super.add(s, c);
    }

    @Override
    public void add(Component c, Object o, int i) {
        this.transparentize(c);
        super.add(c, o, i);
    }

    @Override
    public Component add(Component c, int i) {
        this.transparentize(c);
        return super.add(c, i);
    }

    @Override
    public Component add(Component c) {
        this.transparentize(c);
        return super.add(c);
    }

    public void transparentize(Component c) {
        if (Platform.isMac() && JAlbum.isUsingSystemLAF()) {
            boolean isJComponent = c instanceof JComponent;
            boolean isTextComponent = c instanceof JTextComponent;
            if (!isJComponent || !isTextComponent) {
                // empty if block
            }
        }
    }

    public void setUseExtraSpace(boolean extraSpace) {
        this.useExtraSpace = extraSpace;
    }

    @Override
    public void importVariables(Map<String, Object> skinVariables) {
    }
}

